/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.data.fastjson2;

import cn.zhxu.data.Array;
import cn.zhxu.data.Mapper;
import cn.zhxu.data.fastjson2.Fastjson2Mapper;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import java.util.List;

public class Fastjson2Array
implements Array {
    private final JSONArray json;

    public Fastjson2Array(JSONArray json) {
        this.json = json;
    }

    public int size() {
        return this.json.size();
    }

    public boolean isEmpty() {
        return this.json.isEmpty();
    }

    public Mapper getMapper(int index) {
        JSONObject subJson = this.json.getJSONObject(index);
        if (subJson != null) {
            return new Fastjson2Mapper(subJson);
        }
        return null;
    }

    public Array getArray(int index) {
        JSONArray subJson = this.json.getJSONArray(index);
        if (subJson != null) {
            return new Fastjson2Array(subJson);
        }
        return null;
    }

    public boolean getBool(int index) {
        return this.json.getBooleanValue(index);
    }

    public int getInt(int index) {
        return this.json.getIntValue(index);
    }

    public long getLong(int index) {
        return this.json.getLongValue(index);
    }

    public float getFloat(int index) {
        return this.json.getFloatValue(index);
    }

    public double getDouble(int index) {
        return this.json.getDoubleValue(index);
    }

    public String getString(int index) {
        return this.json.getString(index);
    }

    public <T> List<T> toList(Class<T> type) {
        return this.json.toList(type, new JSONReader.Feature[0]);
    }

    public List<Object> toList() {
        return this.json;
    }

    public String toPretty() {
        return this.json.toString(new JSONWriter.Feature[]{JSONWriter.Feature.PrettyFormat});
    }

    public JSONArray getJson() {
        return this.json;
    }

    public String toString() {
        return this.json.toJSONString(new JSONWriter.Feature[0]);
    }

    public byte[] toJSONBBytes(JSONWriter.Feature ... features) {
        return this.json.toJSONBBytes(features);
    }
}

