/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.okhttps;

import cn.zhxu.okhttps.HttpResult;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class DownloadHelper {
    private Map<String, String> extMappings = new HashMap<String, String>();

    public DownloadHelper() {
        this.extMappings.put("text/plain", "txt");
        this.extMappings.put("audio/mpeg", "mp3");
        this.extMappings.put("video/mpeg4", "mp4");
        this.extMappings.put("video/quicktime", "mov");
        this.extMappings.put("application/x-genesis-rom", "md");
        this.extMappings.put("application/x-xls", "xls");
        this.extMappings.put("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "xlsx");
        this.extMappings.put("application/vnd.android.package-archive", "apk");
        this.extMappings.put("application/msword", "doc");
        this.extMappings.put("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "docx");
        this.extMappings.put("application/x-java-archive", "jar");
        this.extMappings.put("application/x-zip-compressed", "zip");
        this.extMappings.put("application/x-compressed-tar", "tar.gz");
        this.extMappings.put("application/x-rar", "rar");
    }

    public String resolveFileName(HttpResult result) {
        String contentDisposition = result.getHeader("Content-Disposition");
        if (contentDisposition == null || contentDisposition.length() < 1) {
            String urlPath = result.getTask().getUrl();
            String urlName = urlPath.substring(urlPath.lastIndexOf("/") + 1);
            return this.toFileName(urlName, result).replaceAll("[\"\\\\]", "");
        }
        try {
            String filename = URLDecoder.decode(contentDisposition.substring(contentDisposition.indexOf("filename=") + 9), StandardCharsets.UTF_8.name());
            return filename.replaceAll("[\"/\\\\]", "");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toFileName(String name, HttpResult result) {
        int dotIdx = name.lastIndexOf(46);
        if (dotIdx > -1 && dotIdx < name.length() - 1) {
            return name;
        }
        String ext = this.getExt(result.getHeader("Content-Type"));
        if (ext != null) {
            if (dotIdx == -1) {
                return name + "." + ext;
            }
            return name + ext;
        }
        return name;
    }

    public String getExt(String contentType) {
        int i;
        String ext = this.extMappings.get(contentType);
        if (ext == null && (i = contentType.indexOf(47)) > 0 && i < contentType.length() - 1) {
            return contentType.substring(i + 1);
        }
        return ext;
    }

    public String resolveFilePath(String dirPath, String fileName) {
        if (dirPath.endsWith("\\") || dirPath.endsWith("/")) {
            return dirPath + fileName;
        }
        return dirPath + File.separator + fileName;
    }

    public String indexFileName(String fileName, int index) {
        int i = fileName.lastIndexOf(46);
        if (i < 0) {
            return fileName + "(" + index + ")";
        }
        String ext = fileName.substring(i);
        if (i > 0) {
            String name = fileName.substring(0, i);
            return name + "(" + index + ")" + ext;
        }
        return "(" + index + ")" + ext;
    }

    public Map<String, String> getExtMappings() {
        return this.extMappings;
    }

    public void setExtMappings(Map<String, String> extMappings) {
        this.extMappings = extMappings;
    }

    public void addExtMappings(Map<String, String> extMappings) {
        this.extMappings.putAll(extMappings);
    }

    public void addExtMapping(String mediaType, String ext) {
        this.extMappings.put(mediaType, ext);
    }
}

