/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.okhttps;

import cn.zhxu.data.Array;
import cn.zhxu.data.DataConvertor;
import cn.zhxu.data.DataSet;
import cn.zhxu.data.Mapper;
import cn.zhxu.okhttps.OkHttpsException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.List;

public interface MsgConvertor
extends DataConvertor {
    public String mediaType();

    public static class FormConvertor
    implements MsgConvertor {
        private final DataConvertor convertor;
        private final boolean urlEncoded;

        public FormConvertor(DataConvertor convertor) {
            this(convertor, false);
        }

        public FormConvertor(DataConvertor convertor, boolean urlEncoded) {
            this.convertor = convertor;
            this.urlEncoded = urlEncoded;
        }

        @Override
        public String mediaType() {
            return "application/x-www-form-urlencoded";
        }

        public Mapper toMapper(InputStream in, Charset charset) {
            return this.convertor.toMapper(in, charset);
        }

        public Array toArray(InputStream in, Charset charset) {
            return this.convertor.toArray(in, charset);
        }

        public byte[] serialize(Object object, Charset charset, boolean pretty) {
            byte[] result = this.convertor.serialize(object, charset);
            Mapper mapper = this.convertor.toMapper((InputStream)new ByteArrayInputStream(result), charset);
            StringBuilder sb = new StringBuilder();
            mapper.forEach((key, data) -> {
                String value = this.encodeValue((DataSet.Data)data, charset);
                sb.append((String)key).append('=').append(value).append('&');
            });
            int endIndex = sb.length() > 1 ? sb.length() - 1 : sb.length();
            return sb.substring(0, endIndex).getBytes(charset);
        }

        private String encodeValue(DataSet.Data data, Charset charset) {
            String value = data.toString();
            if (this.urlEncoded) {
                try {
                    return URLEncoder.encode(value, charset.name());
                }
                catch (UnsupportedEncodingException e) {
                    throw new OkHttpsException("UnsupportedEncoding: " + charset.name(), e);
                }
            }
            return value;
        }

        public <T> T toBean(Type type, InputStream in, Charset charset) {
            return (T)this.convertor.toBean(type, in, charset);
        }

        public <T> List<T> toList(Class<T> type, InputStream in, Charset charset) {
            return this.convertor.toList(type, in, charset);
        }

        public DataConvertor getConvertor() {
            return this.convertor;
        }

        public boolean isUrlEncoded() {
            return this.urlEncoded;
        }
    }
}

