/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.okhttps.internal;

import cn.zhxu.okhttps.Process;
import cn.zhxu.okhttps.internal.RealProcess;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class ProcessInputStream
extends InputStream {
    private final InputStream input;
    private final Consumer<Process> onProcess;
    private final Executor callbackExecutor;
    private final long stepBytes;
    private final RealProcess process;
    private boolean doneCalled = false;
    private long step;

    public ProcessInputStream(InputStream input, Consumer<Process> onProcess, long totalBytes, long stepBytes, long doneBytes, Executor callbackExecutor) {
        this.input = input;
        this.onProcess = onProcess;
        this.stepBytes = stepBytes;
        this.callbackExecutor = callbackExecutor;
        this.process = new RealProcess(totalBytes, doneBytes);
        this.step = doneBytes / stepBytes;
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        int count = this.read(buf, 0, 1);
        if (count > 0) {
            return buf[0];
        }
        return -1;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int total;
        int read;
        for (total = 0; total < len; total += read) {
            int length = Math.min(len - total, (int)this.stepBytes);
            read = this.input.read(buf, off + total, length);
            if (read == -1) {
                if (total != 0) break;
                return read;
            }
            this.updateProcess(read);
        }
        return total;
    }

    private void updateProcess(long count) {
        this.process.addDoneBytes(count);
        if (this.process.isUndoneAndUnreached(this.step * this.stepBytes)) {
            return;
        }
        if (this.process.isDone()) {
            if (this.doneCalled) {
                return;
            }
            this.doneCalled = true;
        }
        this.step = (this.process.getDoneBytes() - 1L) / this.stepBytes + 1L;
        Process p = this.process.newProcess();
        this.callbackExecutor.execute(() -> this.onProcess.accept(p));
    }

    @Override
    public int available() throws IOException {
        return this.input.available();
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

