/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.xjson;

import cn.zhxu.data.Array;
import cn.zhxu.data.Mapper;
import cn.zhxu.data.TypeRef;
import cn.zhxu.xjson.spi.Config;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class JsonbKit {
    private static final Charset CHARSET = StandardCharsets.UTF_8;

    public static Mapper toMapper(String jsonbBase64) {
        return Config.jsonb().toMapper(jsonbBase64);
    }

    public static Mapper toMapper(byte[] jsonbBytes) {
        return Config.jsonb().toMapper((InputStream)new ByteArrayInputStream(jsonbBytes), CHARSET);
    }

    public static Array toArray(String jsonbBase64) {
        return Config.jsonb().toArray(jsonbBase64);
    }

    public static Array toArray(byte[] jsonbBytes) {
        return Config.jsonb().toArray((InputStream)new ByteArrayInputStream(jsonbBytes), CHARSET);
    }

    public static <T> T toBean(Type type, String jsonbBase64) {
        return (T)Config.jsonb().toBean(type, jsonbBase64);
    }

    public static <T> T toBean(Type type, byte[] jsonbBytes) {
        return (T)Config.jsonb().toBean(type, (InputStream)new ByteArrayInputStream(jsonbBytes), CHARSET);
    }

    public static <T> T toBean(TypeRef<T> typeRef, String jsonbBase64) {
        return JsonbKit.toBean(typeRef.getType(), jsonbBase64);
    }

    public static <T> T toBean(TypeRef<T> typeRef, byte[] jsonbBytes) {
        return JsonbKit.toBean(typeRef.getType(), jsonbBytes);
    }

    public static <T> List<T> toList(Class<T> type, String jsonbBase64) {
        return Config.jsonb().toList(type, jsonbBase64);
    }

    public static <T> List<T> toList(Class<T> type, byte[] jsonbBytes) {
        return Config.jsonb().toList(type, (InputStream)new ByteArrayInputStream(jsonbBytes), CHARSET);
    }

    public static String toBase64(Object object) {
        return Config.jsonb().serialize(object);
    }

    public static byte[] toBytes(Object object) {
        return Config.jsonb().serialize(object, CHARSET);
    }
}

