/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.xjson;

import cn.zhxu.data.Array;
import cn.zhxu.data.Mapper;
import cn.zhxu.data.TypeRef;
import cn.zhxu.xjson.spi.Config;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class XmlKit {
    private static final Charset CHARSET = StandardCharsets.UTF_8;

    public static Mapper toMapper(String xml) {
        return Config.xml().toMapper(xml);
    }

    public static Mapper toMapper(byte[] xmlBytes) {
        return Config.xml().toMapper((InputStream)new ByteArrayInputStream(xmlBytes), CHARSET);
    }

    public static Array toArray(String xml) {
        return Config.xml().toArray(xml);
    }

    public static Array toArray(byte[] xmlBytes) {
        return Config.xml().toArray((InputStream)new ByteArrayInputStream(xmlBytes), CHARSET);
    }

    public static <T> T toBean(Type type, String xml) {
        return (T)Config.xml().toBean(type, xml);
    }

    public static <T> T toBean(Type type, byte[] xmlBytes) {
        return (T)Config.xml().toBean(type, (InputStream)new ByteArrayInputStream(xmlBytes), CHARSET);
    }

    public static <T> T toBean(TypeRef<T> typeRef, String xml) {
        return XmlKit.toBean(typeRef.getType(), xml);
    }

    public static <T> T toBean(TypeRef<T> typeRef, byte[] xmlBytes) {
        return XmlKit.toBean(typeRef.getType(), xmlBytes);
    }

    public static <T> List<T> toList(Class<T> type, String xml) {
        return Config.xml().toList(type, xml);
    }

    public static <T> List<T> toList(Class<T> type, byte[] xmlBytes) {
        return Config.xml().toList(type, (InputStream)new ByteArrayInputStream(xmlBytes), CHARSET);
    }

    public static String toXml(Object object) {
        return Config.xml().serialize(object);
    }

    public static byte[] toBytes(Object object) {
        return Config.xml().serialize(object, CHARSET);
    }
}

