package cn.zkdcloud.framework.render;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import cn.zkdcloud.framework.servlet.HttpContext;

public abstract class AbstractRender implements Render{
	private Map<String,Object> modelMap = new HashMap();
	
	protected HttpServletRequest request;
	
	protected HttpServletResponse response;
	
	public AbstractRender(){
		
	}
	
	public AbstractRender(HttpContext context){
		this.request = context.getRequest();
		this.response = context.getResponse();
	}
	
	public abstract void doRender(HttpContext context);
	
	public Map<String, Object> getModelMap() {
		return modelMap;
	}

	public void setModelMap(Map<String, Object> modelMap) {
		this.modelMap = modelMap;
	}
}
