package cn.zkdcloud.framework.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class Proty {
	private static String SERVER = "server";
	private static Properties property = new Properties();

	static{
		try {
			property.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("classpath:local.properties"));
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}



	/** get value by key
	 *
	 * @param key key
	 * @return value
	 */
	public static String get(String key){
		return property.getProperty(key);
	}

	/** get the var of {server}
	 *
	 * @return value
	 */
	public static String getServer(){
		return property.getProperty(SERVER);
	}
	/** get template path of freemarker
	 *
	 * @return value
	 */
	public static String getFreemarkerPath(){
		return Thread.currentThread().getContextClassLoader().getResource("").getPath() + get("freemarkerPath");
	}

	/**
	 *  handler static resources
	 */
	public static class StaticResources{
		private static String STATIC_PATHS = "staticPath";
		private static List<String> staticPaths = new ArrayList<String>();

		static {
			String[] sps =  property.getProperty(STATIC_PATHS).split(",");
			for(String staticPath : sps){
				staticPaths.add(staticPath.trim());
			}
		}
		public static boolean isStaticPath(String path){
			for(String antPath : staticPaths){
				if(AntPathMatcher.match(antPath,path))
					return true;
			}
			return false;
		}
	}
}
