/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.adbanner;

import android.app.Activity;
import android.os.Handler;
import co.adcel.adbanner.BannerAdContainer;
import co.adcel.adbanner.BannerAdProviderPopulateBase;
import co.adcel.adbanner.BannerAdTest;
import co.adcel.adbanner.BannerAdsManager;
import co.adcel.adbanner.BannerProvider;
import co.adcel.ads.mediation.DefaultDependenciesFactory;
import co.adcel.ads.mediation.LogService;
import co.adcel.ads.mediation.MediationContext;
import co.adcel.ads.mediation.SdkLog;
import co.adcel.common.AdProviderDTO;
import co.adcel.common.ProviderUpdateAction;
import co.adcel.init.AdCel;
import co.adcel.logger.AdsATALog;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class AdCelBanner
implements BannerAdsManager.OnPriorityListCreatedListener {
    private static final int ATTEMPT_COUNT = 10;
    private static final int TIMEOUT_SEC = 15;
    private static final int INIT_TIMEOUT_SEC = 5;
    static Boolean isBannerAvailable = false;
    private List<BannerProvider> adProvidersList = new ArrayList<BannerProvider>();
    private int adProviderIndex = 0;
    private int attemptNextCount = 0;
    private String lastLoadedProvider;
    private BannerAdsManager bannerAdsManager;
    private BannerAdContainer bac;
    private String sessionId = "";
    private ScheduledExecutorService bannerInitWorker;
    private ScheduledFuture bannerInitFuture;
    private ScheduledExecutorService bannerReInitWorker;
    private ScheduledFuture bannerReInitFuture;

    public static boolean isBannerAvailable() {
        return isBannerAvailable;
    }

    protected BannerAdsManager getBannerAdsManager() {
        return this.bannerAdsManager;
    }

    protected AdCelBanner(BannerAdContainer bac) {
        this.bac = bac;
        this.bannerAdsManager = AdCel.getMediationContextForBanner(this).getBannerAdsManager();
    }

    void attach() {
        this.bannerAdsManager.addOnPriorityListCreatedListener(this);
    }

    void destroy() {
        this.bannerAdsManager.removeOnPriorityListCreatedListener(this);
    }

    @Override
    public void onPriorityListCreated() {
        if (AdCel.isTestModeEnabled()) {
            MediationContext aContext = AdCel.getMediationContextForBanner(this);
            BannerAdTest testBanner = new BannerAdTest(this.bac.getContext());
            testBanner.createBanner(this.bac, aContext.isWaterFallInitialized(), aContext.isModerated());
        } else {
            this.createProviderPriorityLists();
        }
    }

    protected boolean isProviderActive(String providerName) {
        return this.adProvidersList.size() > 0 && this.adProviderIndex < this.adProvidersList.size() && this.adProvidersList.get(this.adProviderIndex).getProviderDTO().getProviderName().equals(providerName);
    }

    protected boolean isProviderHighestECPM(String providerName) {
        return this.adProvidersList.size() > 0 && this.adProvidersList.get(0).getProviderDTO().getProviderName().equals(providerName);
    }

    private void startCheckInit() {
        if (this.bannerInitWorker != null && this.bannerInitFuture != null) {
            return;
        }
        final int checkIndex = this.adProviderIndex;
        Runnable checkInit = new Runnable(){

            @Override
            public void run() {
                if (AdCelBanner.this.bannerInitFuture != null) {
                    AdCelBanner.this.bannerInitFuture = null;
                }
                if (AdCelBanner.this.bannerInitWorker != null) {
                    AdCelBanner.this.bannerInitWorker = null;
                }
                if (checkIndex == AdCelBanner.this.adProviderIndex && !AdCelBanner.isBannerAvailable()) {
                    AdsATALog.i("#ADSMANAGER-BANNER NOTIFICATION: INITIALIZATION TIMED OUT");
                    AdCelBanner.this.nextProviderToShowAd();
                }
            }
        };
        if (this.bannerInitFuture != null) {
            this.bannerInitFuture.cancel(true);
            this.bannerInitFuture = null;
        }
        if (this.bannerInitWorker != null) {
            this.bannerInitWorker = null;
        }
        this.bannerInitWorker = Executors.newSingleThreadScheduledExecutor();
        this.bannerInitFuture = this.bannerInitWorker.schedule(checkInit, 5L, TimeUnit.SECONDS);
    }

    protected void initializeProvider() {
        isBannerAvailable = false;
        if (this.adProviderIndex < this.adProvidersList.size()) {
            final BannerProvider provider = this.adProvidersList.get(this.adProviderIndex);
            new Handler(this.bac.getContext().getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    provider.initializeProviderSDK(AdCelBanner.this.bac.getContext(), AdCelBanner.this.bac);
                }
            });
            this.startCheckInit();
        } else {
            this.nextProviderToShowAd();
        }
    }

    void providerLoadedFail() {
        BannerProvider providerInst = null;
        AdProviderDTO providerDto = null;
        if (this.adProviderIndex < this.adProvidersList.size() && this.adProviderIndex >= 0) {
            providerInst = this.adProvidersList.get(this.adProviderIndex);
            providerDto = providerInst.getProviderDTO();
            this.bac.notifyBannerFailedToLoad(providerDto.getProviderName());
        }
        if (providerInst != null && providerDto != null) {
            this.sendLog(new SdkLog.Builder().isOK(true).waterfallIndex(this.adProviderIndex).providerId(Integer.parseInt(providerDto.getProviderId())).rtbProviderId(providerInst.getRtbProviderId()).errorCode(92786).sessionId(this.sessionId + "_X").format("banner").build());
        }
        this.nextProviderToShowAd();
    }

    protected void nextProviderToShowAd() {
        if (this.bannerReInitWorker != null && this.bannerReInitFuture != null) {
            return;
        }
        this.lastLoadedProvider = null;
        if (this.adProvidersList.size() > 0) {
            if (this.adProviderIndex < this.adProvidersList.size() && this.adProviderIndex >= 0) {
                BannerProvider providerInst = this.adProvidersList.get(this.adProviderIndex);
                AdProviderDTO providerDto = providerInst.getProviderDTO();
                this.sendLog(new SdkLog.Builder().waterfallIndex(this.adProviderIndex).providerId(Integer.parseInt(providerDto.getProviderId())).rtbProviderId(providerInst.getRtbProviderId()).errorCode(72414).format("banner").sessionId(this.sessionId).build());
            }
            ++this.adProviderIndex;
            if (this.adProvidersList.size() <= this.adProviderIndex) {
                this.adProviderIndex = 0;
                this.bac.notifyBannerFailedToLoad();
            }
            Runnable switchProvider = new Runnable(){

                @Override
                public void run() {
                    if (isBannerAvailable.booleanValue() && AdCelBanner.this.bac.getChildCount() > 0) {
                        return;
                    }
                    AdCelBanner.this.attemptNextCount++;
                    if (AdCelBanner.this.adProviderIndex < AdCelBanner.this.adProvidersList.size()) {
                        AdsATALog.i("#ADSMANAGER-BANNER NOTIFICATION: SWITCHED TO THE PROVIDER: " + ((BannerProvider)AdCelBanner.this.adProvidersList.get(AdCelBanner.this.adProviderIndex)).getProviderDTO().getProviderName() + " attempt " + AdCelBanner.this.attemptNextCount);
                    }
                    if (AdCelBanner.this.bannerReInitFuture != null) {
                        AdCelBanner.this.bannerReInitFuture = null;
                    }
                    if (AdCelBanner.this.bannerReInitWorker != null) {
                        AdCelBanner.this.bannerReInitWorker = null;
                    }
                    AdCelBanner.this.initializeProvider();
                }
            };
            if (this.attemptNextCount / this.adProvidersList.size() > 10) {
                this.attemptNextCount = 0;
                this.adProviderIndex = 0;
                AdsATALog.i("#ADSMANAGER-BANNER NOTIFICATION: There is no available Banner AdProvider for further initialization.");
            } else if (this.attemptNextCount > 0 && this.attemptNextCount % this.adProvidersList.size() == 0) {
                if (this.bannerReInitFuture != null) {
                    this.bannerReInitFuture.cancel(true);
                    this.bannerReInitFuture = null;
                }
                if (this.bannerReInitWorker != null) {
                    this.bannerReInitWorker = null;
                }
                this.bannerReInitWorker = Executors.newSingleThreadScheduledExecutor();
                this.bannerReInitFuture = this.bannerReInitWorker.schedule(switchProvider, 15L, TimeUnit.SECONDS);
            } else {
                switchProvider.run();
            }
        } else {
            AdsATALog.i("#ADSMANAGER-BANNER NOTIFICATION: There is no available Banner AdProvider for further initialization.");
        }
    }

    protected void initializeProviderCrash(String provider, Activity activity) {
        AdsATALog.i(String.format("#ADSMANAGER-BANNER NOTIFICATION: Provider %s initialize crash.", provider));
        for (int inx = 0; inx < this.adProvidersList.size(); ++inx) {
            BannerProvider providerInst = this.adProvidersList.get(inx);
            AdProviderDTO providerDto = providerInst.getProviderDTO();
            if (!providerDto.getProviderName().equals(provider)) continue;
            this.sendLog(new SdkLog.Builder().format("banner").waterfallIndex(-3).providerId(Integer.parseInt(providerDto.getProviderId())).rtbProviderId(providerInst.getRtbProviderId()).errorCode(72418).sessionId("I").build());
            break;
        }
    }

    protected void providerLoadedSuccess(String provider) {
        isBannerAvailable = true;
        if (this.adProviderIndex < this.adProvidersList.size() && this.adProviderIndex >= 0) {
            BannerProvider providerInst = this.adProvidersList.get(this.adProviderIndex);
            AdProviderDTO providerDto = providerInst.getProviderDTO();
            int providerId = Integer.parseInt(providerDto.getProviderId());
            this.sendLog(new SdkLog.Builder().isOK(true).waterfallIndex(this.adProviderIndex).providerId(providerId).rtbProviderId(providerInst.getRtbProviderId()).sessionId(this.sessionId).format("banner").build());
            this.sendLog(new SdkLog.Builder().isOK(true).waterfallIndex(this.adProviderIndex).providerId(providerId).rtbProviderId(providerInst.getRtbProviderId()).errorCode(92785).sessionId(this.sessionId + "_X").format("banner").build());
        }
        this.lastLoadedProvider = provider;
        this.attemptNextCount = 0;
    }

    void providerClick() {
        if (this.adProviderIndex < this.adProvidersList.size() && this.adProviderIndex >= 0) {
            BannerProvider providerInst = this.adProvidersList.get(this.adProviderIndex);
            AdProviderDTO providerDto = providerInst.getProviderDTO();
            this.sendLog(new SdkLog.Builder().isOK(true).isClicked(true).waterfallIndex(this.adProviderIndex).providerId(Integer.parseInt(providerDto.getProviderId())).rtbProviderId(providerInst.getRtbProviderId()).sessionId(this.sessionId).format("banner").build());
        }
    }

    private String generateSessionId() {
        MediationContext aContext = this.bannerAdsManager.getMediationContext();
        return aContext.generateSessionId("banner");
    }

    protected void createProviderPriorityLists() {
        AdsATALog.i("AdCelSDK: Banner module initialization started.");
        MediationContext aContext = this.bannerAdsManager.getMediationContext();
        BannerAdProviderPopulateBase populateAdapter = new BannerAdProviderPopulateBase(aContext);
        try {
            this.adProvidersList = new ArrayList<BannerProvider>();
            List<String> queue = aContext.getProvidersQueues().get("banner");
            populateAdapter.populate(this.adProvidersList, queue);
            this.adProviderIndex = 0;
            if (this.adProvidersList.size() > 0) {
                this.sessionId = this.generateSessionId();
                this.initializeProvider();
                AdsATALog.i("==========\nAdCelSDK: Instantiating BannerProvider with the highest eCPM...");
            } else {
                AdsATALog.i("#ADSMANAGER-BANNER NOTIFICATION: There is no available Banner AdProvider for further initialization.");
                this.bac.notifyBannerFailedToLoad();
            }
        }
        catch (NullPointerException e) {
            AdsATALog.e("AdCelBanner error: " + e.getMessage());
        }
    }

    private void stopWorkers() {
        if (this.bannerInitFuture != null) {
            this.bannerInitFuture.cancel(true);
            this.bannerInitFuture = null;
        }
        if (this.bannerInitWorker != null) {
            this.bannerInitWorker = null;
        }
        if (this.bannerReInitFuture != null) {
            this.bannerReInitFuture.cancel(true);
            this.bannerReInitFuture = null;
        }
        if (this.bannerReInitWorker != null) {
            this.bannerReInitWorker = null;
        }
    }

    protected void updateProvidersSDK(ProviderUpdateAction action, Activity activity) {
        AdsATALog.i("AdCelSDK: " + this.getClass().getName() + ".updateProvidersSDK(" + (Object)((Object)action) + ")");
        if (action == ProviderUpdateAction.PAUSE) {
            this.stopWorkers();
        }
        for (int inx = 0; inx < this.adProvidersList.size(); ++inx) {
            try {
                BannerProvider providerIns = this.adProvidersList.get(inx);
                if (providerIns == null || providerIns.getInitializationState() == 0) continue;
                providerIns.updateProviderSDK(action, activity);
                continue;
            }
            catch (Throwable e) {
                AdsATALog.e(e.getMessage(), e);
            }
        }
    }

    protected void setAutoRefreshProvidersSDK(boolean autoRefresh) {
        AdsATALog.i("AdCelSDK: " + this.getClass().getName() + ".setAutoRefresh(" + autoRefresh + ")");
        for (int inx = 0; inx < this.adProvidersList.size(); ++inx) {
            BannerProvider providerIns = this.adProvidersList.get(inx);
            if (providerIns == null) continue;
            providerIns.setAutoRefresh(autoRefresh);
        }
    }

    protected void loadNextAd() {
        if (this.adProvidersList.size() == 0) {
            return;
        }
        try {
            this.adProviderIndex = 0;
            this.adProvidersList.get(this.adProviderIndex).loadNextAd();
        }
        catch (NullPointerException e) {
            AdsATALog.i("#ADSMANAGER-BANNER NOTIFICATION: There is no available Banner AdProvider. Probably you didn't initialize this adType.");
            isBannerAvailable = false;
            this.adProviderIndex = -1;
            this.nextProviderToShowAd();
        }
    }

    private void sendLog(SdkLog sdkLog) {
        LogService logService = DefaultDependenciesFactory.logService();
        if (logService == null) {
            return;
        }
        logService.send(sdkLog);
    }
}

