/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.adbanner;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import co.adcel.adbanner.AdCelBanner;
import co.adcel.adbanner.AdSize;
import co.adcel.adbanner.BannerListener;
import co.adcel.ads.mediation.MediationContext;
import co.adcel.common.ProviderUpdateAction;
import co.adcel.common.Utilities;
import co.adcel.init.AdCel;
import co.adcel.logger.AdsATALog;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class BannerAdContainer
extends LinearLayout {
    AdCelBanner manager = new AdCelBanner(this);
    private AdSize adSize = AdSize.BANNER_320x50;
    private ScheduledExecutorService worker = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture future;
    private boolean isStarted = false;
    private boolean isPause = false;
    private boolean isAutoRefreshAd = false;
    private int refreshInterval = 0;
    private BannerListener bannerListener;

    public BannerAdContainer(Context context) {
        super(context);
        this.createBanner(context);
    }

    public BannerAdContainer(Context context, AttributeSet attrs) {
        super(context, attrs);
        String adSize = attrs.getAttributeValue(null, "adSize");
        if (adSize != null) {
            switch (adSize) {
                case "BANNER_320x50": {
                    this.adSize = AdSize.BANNER_320x50;
                    break;
                }
                case "BANNER_300x50": {
                    this.adSize = AdSize.BANNER_300x50;
                    break;
                }
                case "BANNER_300x250": {
                    this.adSize = AdSize.BANNER_300x250;
                    break;
                }
                case "BANNER_728x90": {
                    this.adSize = AdSize.BANNER_728x90;
                }
            }
        }
        this.createBanner(context);
    }

    private void createBanner(Context context) {
        MediationContext aContext = AdCel.getMediationContextForBanner(this.manager);
        if (context instanceof Activity) {
            aContext.setContext((Activity)context);
        }
        this.setGravity(17);
    }

    public void setSize(AdSize adSize) {
        this.adSize = adSize;
    }

    public AdSize getSize() {
        return this.adSize;
    }

    public void setBannerListener(BannerListener bannerListener) {
        this.bannerListener = bannerListener;
    }

    public void addView(View child) {
        this.addView(child, null);
    }

    public void addView(final View child, final ViewGroup.LayoutParams params) {
        new Handler(this.getContext().getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                if (child == null) {
                    AdsATALog.i("#WARNING: BannerAdContainer.addView() Banner view empty!");
                    return;
                }
                if (child.getParent() != null) {
                    ((ViewGroup)child.getParent()).removeView(child);
                }
                if (!BannerAdContainer.this.containView(child.getTag())) {
                    BannerAdContainer.super.removeAllViews();
                    child.setTag((Object)child.hashCode());
                    if (params != null) {
                        BannerAdContainer.super.addView(child, params);
                    } else {
                        BannerAdContainer.super.addView(child);
                    }
                }
                BannerAdContainer.super.invalidate();
            }
        });
    }

    private boolean containView(Object tag) {
        if (tag == null) {
            return false;
        }
        int chCnt = this.getChildCount();
        for (int inx = 0; inx < chCnt; ++inx) {
            View child = this.getChildAt(inx);
            Object tagObj = child.getTag();
            if (tagObj == null || !tagObj.equals(tag)) continue;
            return true;
        }
        return false;
    }

    public void removeAllViews() {
        new Handler(this.getContext().getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                BannerAdContainer.super.removeAllViews();
            }
        });
    }

    protected void onMeasure(int wSpec, int hSpec) {
        super.onMeasure(wSpec, hSpec);
    }

    private void attach() {
        if (this.isStarted) {
            return;
        }
        this.isStarted = true;
        this.manager.attach();
        if (this.isAutoRefreshAd) {
            this.refreshAd();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.attach();
    }

    protected void onDetachedFromWindow() {
        this.detachBanner();
        super.onDetachedFromWindow();
    }

    public void start() {
        new Handler(this.getContext().getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                BannerAdContainer.this.attach();
            }
        });
    }

    public void loadNextAd() {
        new Handler(this.getContext().getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                BannerAdContainer.this.manager.loadNextAd();
            }
        });
    }

    private boolean isEnableAutoRefreshAd() {
        return this.isAutoRefreshAd;
    }

    private void setEnableAutoRefreshAd(boolean isAutoRefreshAd) {
        this.isAutoRefreshAd = isAutoRefreshAd;
        this.manager.setAutoRefreshProvidersSDK(!isAutoRefreshAd);
        if (isAutoRefreshAd) {
            this.refreshAd();
        }
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(int refreshInterval) {
        if (refreshInterval == 0) {
            this.refreshInterval = refreshInterval;
        } else if (refreshInterval >= 25 && refreshInterval <= 120) {
            this.refreshInterval = refreshInterval;
        } else {
            this.refreshInterval = refreshInterval < 25 ? 25 : 120;
            AdsATALog.i(String.format("#WARNING: Please set refreshInterval between 25 and 120 sec. Current value is set to %d sec.", refreshInterval));
        }
        this.setEnableAutoRefreshAd(this.refreshInterval > 0);
    }

    private void refreshAd() {
        if (this.future != null) {
            this.future.cancel(false);
        }
        if (this.worker == null) {
            this.worker = Executors.newSingleThreadScheduledExecutor();
        }
        this.future = this.worker.schedule(new Runnable(){

            @Override
            public void run() {
                if (BannerAdContainer.this.isAutoRefreshAd && !BannerAdContainer.this.isPause) {
                    BannerAdContainer.this.loadNextAd();
                    AdsATALog.i(String.format("#BANNER AD CONTAINER =refreshInterval=(%d sec.) RELOAD %d", BannerAdContainer.this.refreshInterval, Thread.currentThread().getId()));
                    BannerAdContainer.this.refreshAd();
                } else {
                    BannerAdContainer.this.future.cancel(false);
                }
            }
        }, (long)this.refreshInterval, TimeUnit.SECONDS);
    }

    private void detachBanner() {
        try {
            this.isPause = true;
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
            if (this.worker != null) {
                this.worker.shutdown();
                this.worker = null;
            }
            AdsATALog.i("#BANNER AD CONTAINER detached!");
        }
        catch (Exception e) {
            AdsATALog.i("#BANNER AD CONTAINER detached error: " + e.getMessage());
        }
    }

    public void pause() {
        this.isPause = true;
        this.manager.updateProvidersSDK(ProviderUpdateAction.PAUSE, (Activity)this.getContext());
    }

    public void resume() {
        this.manager.updateProvidersSDK(ProviderUpdateAction.RESUME, (Activity)this.getContext());
        this.isPause = false;
        this.refreshAd();
    }

    public void destroy() {
        this.manager.updateProvidersSDK(ProviderUpdateAction.DESTROY, (Activity)this.getContext());
        this.manager.destroy();
    }

    protected void notifyBannerLoad() {
        Utilities.checkActivityLifeCycleSync();
        Activity activity = (Activity)this.getContext();
        if (this.bannerListener != null && activity != null) {
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    BannerAdContainer.this.bannerListener.onBannerLoad();
                }
            });
        }
    }

    protected void notifyBannerFailedToLoad() {
        Utilities.checkActivityLifeCycleSync();
        Activity activity = (Activity)this.getContext();
        if (this.bannerListener != null && activity != null) {
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    BannerAdContainer.this.bannerListener.onBannerFailedToLoad();
                }
            });
        }
    }

    protected void notifyBannerFailedToLoad(final String provider) {
        Utilities.checkActivityLifeCycleSync();
        Activity activity = (Activity)this.getContext();
        if (this.bannerListener != null && activity != null) {
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    BannerAdContainer.this.bannerListener.onBannerFailedToLoadProvider(provider);
                }
            });
        }
    }

    protected void notifyBannerClicked() {
        Activity activity = (Activity)this.getContext();
        if (this.bannerListener != null && activity != null) {
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    BannerAdContainer.this.bannerListener.onBannerClicked();
                }
            });
        }
        this.loadNextAd();
    }
}

