/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.adbanner;

import co.adcel.adbanner.BannerAdProviderPopulateAdapter;
import co.adcel.adbanner.BannerProvider;
import co.adcel.ads.mediation.MediationContext;
import co.adcel.common.AdProviderDTO;
import co.adcel.logger.AdsATALog;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BannerAdProviderPopulateBase
implements BannerAdProviderPopulateAdapter {
    private MediationContext aContext;
    private Map<String, String> providerMap;

    BannerAdProviderPopulateBase(MediationContext aContext) {
        this.aContext = aContext;
        this.providerMap = new HashMap<String, String>();
        this.providerMap.put("Google Admob", "co.adcel.adbanner.ProviderAdMob");
        this.providerMap.put("MyTarget", "co.adcel.adbanner.ProviderMyTarget");
        this.providerMap.put("StartApp", "co.adcel.adbanner.ProviderStartApp");
        this.providerMap.put("Smaato", "co.adcel.adbanner.ProviderSmaato");
        this.providerMap.put("Yandex", "co.adcel.adbanner.ProviderYandex");
        this.providerMap.put("Amazon Mobile Ads", "co.adcel.adbanner.ProviderAmazon");
        this.providerMap.put("Facebook", "co.adcel.adbanner.ProviderFacebook");
        this.providerMap.put("MoPub", "co.adcel.adbanner.ProviderMoPub");
        this.providerMap.put("RTB", "co.adcel.adbanner.ProviderAdCel");
        this.providerMap.put("Applovin", "co.adcel.adbanner.ProviderApplovin");
        this.providerMap.put("UnityAds", "co.adcel.adbanner.ProviderUnityAds");
        this.providerMap.put("AdColony", "co.adcel.adbanner.ProviderAdColony");
        this.providerMap.put("InMobi", "co.adcel.adbanner.ProviderInMobi");
        this.providerMap.put("Criteo", "co.adcel.adbanner.ProviderCriteo");
        this.providerMap.put("Vungle", "co.adcel.adbanner.ProviderVungle");
    }

    @Override
    public void populate(List<BannerProvider> adProvidersList, List<String> queue) {
        for (String providerName : queue) {
            String className = this.providerMap.get(providerName);
            if (className == null || this.aContext.isProviderDisabled("banner", providerName)) continue;
            try {
                Class<?> clazz = Class.forName(className);
                Method m = clazz.getDeclaredMethod("isProviderInstalled", new Class[0]);
                m.setAccessible(true);
                boolean installed = (Boolean)m.invoke(null, new Object[0]);
                if (installed) {
                    AdsATALog.i("==== Banner Provider " + providerName + " is installed");
                    AdProviderDTO providerDTO = this.aContext.getProvider(providerName, "banner");
                    if (providerDTO == null) continue;
                    BannerProvider bp = (BannerProvider)clazz.getDeclaredConstructor(AdProviderDTO.class).newInstance(providerDTO);
                    adProvidersList.add(bp);
                    continue;
                }
                AdsATALog.i("==== Banner Provider " + providerName + " is not installed");
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                AdsATALog.i("==== Banner Provider " + providerName + " is not installed");
            }
            catch (Throwable e) {
                AdsATALog.e("==== Banner Provider " + providerName + " instantiate failed: " + e.getMessage());
            }
        }
    }
}

