/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.adbanner;

import co.adcel.ads.mediation.MediationContext;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public final class BannerAdsManager {
    private MediationContext mediationContext;
    private List<WeakReference<OnPriorityListCreatedListener>> onPriorityListCreatedListeners;

    public BannerAdsManager(MediationContext mediationContext) {
        if (mediationContext == null) {
            throw new IllegalArgumentException("mediationContext can't be null");
        }
        this.mediationContext = mediationContext;
        this.onPriorityListCreatedListeners = new ArrayList<WeakReference<OnPriorityListCreatedListener>>();
    }

    public MediationContext getMediationContext() {
        return this.mediationContext;
    }

    public void addOnPriorityListCreatedListener(OnPriorityListCreatedListener onPriorityListCreatedListener) {
        for (int i = 0; i < this.onPriorityListCreatedListeners.size(); ++i) {
            WeakReference<OnPriorityListCreatedListener> refLsnr = this.onPriorityListCreatedListeners.get(i);
            OnPriorityListCreatedListener lsnr = (OnPriorityListCreatedListener)refLsnr.get();
            if (lsnr == null || !lsnr.equals(onPriorityListCreatedListener)) continue;
            return;
        }
        this.onPriorityListCreatedListeners.add(new WeakReference<OnPriorityListCreatedListener>(onPriorityListCreatedListener));
        List<String> queue = this.mediationContext.getProvidersQueues().get("banner");
        if (queue != null && queue.size() > 0 && onPriorityListCreatedListener != null) {
            onPriorityListCreatedListener.onPriorityListCreated();
        }
    }

    public void removeOnPriorityListCreatedListener(OnPriorityListCreatedListener onPriorityListCreatedListener) {
        int idxToRemove = -1;
        for (int i = 0; i < this.onPriorityListCreatedListeners.size(); ++i) {
            WeakReference<OnPriorityListCreatedListener> refLsnr = this.onPriorityListCreatedListeners.get(i);
            OnPriorityListCreatedListener lsnr = (OnPriorityListCreatedListener)refLsnr.get();
            if (lsnr == null || !lsnr.equals(onPriorityListCreatedListener)) continue;
            idxToRemove = i;
            break;
        }
        if (idxToRemove != -1) {
            this.onPriorityListCreatedListeners.remove(idxToRemove);
        }
    }

    private void notifyListeners() {
        int i;
        ArrayList<Integer> idxsForRemove = new ArrayList<Integer>();
        for (i = 0; i < this.onPriorityListCreatedListeners.size(); ++i) {
            WeakReference<OnPriorityListCreatedListener> refLsnr = this.onPriorityListCreatedListeners.get(i);
            OnPriorityListCreatedListener lsnr = (OnPriorityListCreatedListener)refLsnr.get();
            if (lsnr != null) {
                lsnr.onPriorityListCreated();
                continue;
            }
            idxsForRemove.add(i);
        }
        for (i = 0; i < idxsForRemove.size(); ++i) {
            int idx = (Integer)idxsForRemove.get(i);
            if (idx >= this.onPriorityListCreatedListeners.size()) continue;
            this.onPriorityListCreatedListeners.remove(idx);
        }
    }

    public void createProviderPriorityList() {
        this.notifyListeners();
    }

    public static interface OnPriorityListCreatedListener {
        public void onPriorityListCreated();
    }
}

