/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.adbanner;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import co.adcel.adbanner.AdCelBanner;
import co.adcel.adbanner.AdSize;
import co.adcel.adbanner.BannerAdContainer;
import co.adcel.adbanner.BannerProvider;
import co.adcel.common.AdProviderDTO;
import co.adcel.logger.AdsATALog;

public abstract class BannerProviderBase
implements BannerProvider {
    protected BannerAdContainer mBac;
    protected AdProviderDTO providerDTO;
    protected int initializationState = 0;
    protected boolean autoRefresh = true;

    BannerProviderBase(AdProviderDTO providerDTO) {
        this.providerDTO = providerDTO;
    }

    @Override
    public AdProviderDTO getProviderDTO() {
        return this.providerDTO;
    }

    protected AdProviderDTO.BannerSize getBannerForView() {
        if (this.mBac.getSize() == AdSize.BANNER_300x50) {
            return this.getProviderDTO().getBannerForSize(300, 50);
        }
        if (this.mBac.getSize() == AdSize.BANNER_320x50) {
            return this.getProviderDTO().getBannerForSize(320, 50);
        }
        if (this.mBac.getSize() == AdSize.BANNER_300x250) {
            return this.getProviderDTO().getBannerForSize(300, 250);
        }
        if (this.mBac.getSize() == AdSize.BANNER_728x90) {
            return this.getProviderDTO().getBannerForSize(728, 90);
        }
        if (this.mBac == null || this.mBac.getLayoutParams() == null) {
            return this.getProviderDTO().getBannerForSize(320, 50);
        }
        int bacWidth = this.mBac.getLayoutParams().width;
        int bacHeight = this.mBac.getLayoutParams().height;
        float density = this.mBac.getContext().getResources().getDisplayMetrics().density;
        if (bacWidth > 0) {
            bacWidth = (int)((float)bacWidth / density);
        }
        if (bacHeight > 0) {
            bacHeight = (int)((float)bacHeight / density);
        }
        return this.getProviderDTO().getBannerForSize(bacWidth, bacHeight);
    }

    @Override
    public void initializeProviderSDK(final Context context, BannerAdContainer bac) {
        this.mBac = bac;
        if (this.mBac.getSize() != AdSize.BANNER_NOT_DEFINED && !this.getSupportedSizes().contains((Object)this.mBac.getSize())) {
            this.failLoad((Object)((Object)this.mBac.getSize()) + " not supported");
            return;
        }
        ((Activity)this.mBac.getContext()).runOnUiThread(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (Build.VERSION.SDK_INT < BannerProviderBase.this.getMinAndroidApiVer()) {
                        BannerProviderBase.this.failLoad(String.format("%s support only android api %s or higher", BannerProviderBase.this.getProviderDTO().getProviderName(), String.valueOf(BannerProviderBase.this.getMinAndroidApiVer())));
                        return;
                    }
                    try {
                        BannerProviderBase.this.init(context);
                        if (BannerProviderBase.this.initializationState == 0) {
                            BannerProviderBase.this.initializationState = 1;
                        }
                        AdsATALog.i(String.format("#PROVIDER =%s=(Banner) INSTANTIATED", BannerProviderBase.this.providerDTO.getProviderName()));
                    }
                    catch (Throwable e) {
                        System.gc();
                        AdsATALog.e(String.format("#PROVIDER =%s=(Banner) INSTANTIATE FAILED: %s", BannerProviderBase.this.providerDTO.getProviderName(), e.getMessage()));
                        BannerProviderBase.this.mBac.manager.initializeProviderCrash(BannerProviderBase.this.providerDTO.getProviderName(), (Activity)context);
                        if (BannerProviderBase.this.initializationState == 2) break block4;
                        BannerProviderBase.this.initializationState = 2;
                        BannerProviderBase.this.mBac.manager.nextProviderToShowAd();
                    }
                }
            }
        });
    }

    abstract void init(Context var1);

    @Override
    public void setAutoRefresh(boolean autoRefresh) {
        this.autoRefresh = autoRefresh;
    }

    @Override
    public int getInitializationState() {
        return this.initializationState;
    }

    abstract void adToView();

    void loadSuccess() {
        this.initializationState = 3;
        if (!this.mBac.manager.isProviderActive(this.providerDTO.getProviderName()) && !this.mBac.manager.isProviderHighestECPM(this.providerDTO.getProviderName())) {
            return;
        }
        ((Activity)this.mBac.getContext()).runOnUiThread(new Runnable(){

            @Override
            public void run() {
                BannerProviderBase.this.mBac.removeAllViews();
                BannerProviderBase.this.adToView();
            }
        });
        this.mBac.manager.providerLoadedSuccess(this.providerDTO.getProviderName());
        AdsATALog.i(String.format("#PROVIDER =%s=(Banner) AD AVAILABLE", this.providerDTO.getProviderName()));
        this.mBac.notifyBannerLoad();
    }

    void failLoad(String error) {
        this.initializationState = 2;
        if (!this.mBac.manager.isProviderActive(this.providerDTO.getProviderName())) {
            return;
        }
        AdCelBanner.isBannerAvailable = false;
        AdsATALog.i(String.format("#PROVIDER =%s=(Banner) Error: %s", this.providerDTO.getProviderName(), error));
        AdsATALog.i(String.format("#PROVIDER =%s=(Banner) AD UNAVAILABLE. SWITCHING TO THE NEXT PROVIDER...", this.providerDTO.getProviderName()));
        this.mBac.removeAllViews();
        this.mBac.manager.providerLoadedFail();
    }

    void click() {
        this.mBac.notifyBannerClicked();
        this.mBac.manager.providerClick();
    }

    @Override
    public int getRtbProviderId() {
        return 0;
    }

    @Override
    public int getMinAndroidApiVer() {
        return 14;
    }
}

