/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.adbanner;

import android.app.Activity;
import android.content.Context;
import android.location.Location;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import co.adcel.adbanner.AdSize;
import co.adcel.adbanner.BannerProviderBase;
import co.adcel.ads.mediation.MediationContext;
import co.adcel.ads.rtb.BannerAdEventListener;
import co.adcel.ads.rtb.BannerAdView;
import co.adcel.common.AdProviderDTO;
import co.adcel.common.GDPRUserConsent;
import co.adcel.common.ProviderUpdateAction;
import co.adcel.common.TargetingParam;
import co.adcel.init.AdCel;
import java.util.HashSet;
import java.util.Set;

public class ProviderAdCel
extends BannerProviderBase
implements BannerAdEventListener {
    private BannerAdView mBannerAdView;
    private int rtbProviderId = 0;

    static boolean isProviderInstalled() {
        return true;
    }

    ProviderAdCel(AdProviderDTO providerDTO) {
        super(providerDTO);
    }

    @Override
    public void updateProviderSDK(ProviderUpdateAction action, Activity activity) {
        if (this.mBannerAdView == null) {
            return;
        }
        switch (action) {
            case DESTROY: {
                this.mBannerAdView = null;
            }
        }
    }

    @Override
    public void loadNextAd() {
        if (this.mBannerAdView == null) {
            return;
        }
        this.mBannerAdView.load();
    }

    @Override
    void init(Context context) {
        String lon;
        MediationContext aContext = AdCel.getMediationContextForBanner(this.mBac.manager);
        this.mBannerAdView = new BannerAdView(this.mBac.getContext());
        String lat = aContext.getTargetingParam("latitude");
        Location location = TargetingParam.getLocation(lat, lon = aContext.getTargetingParam("longitude"));
        if (location != null) {
            this.mBannerAdView.setLocation(location);
        }
        if (aContext.isGDPRApplicable()) {
            this.mBannerAdView.setGdprConsent(aContext.getGdprUserConsent() == GDPRUserConsent.CONSENT);
        }
        this.mBannerAdView.setSize(this.getAdSize());
        this.mBannerAdView.setKey(aContext.getSdkKey(), this.getProviderDTO().getOptions());
        this.mBannerAdView.setBannerAdEventListener(this);
        this.loadNextAd();
    }

    BannerAdView.BannerSize getAdSize() {
        switch (this.mBac.getSize()) {
            case BANNER_300x250: {
                return new BannerAdView.BannerSize(300, 250);
            }
        }
        return new BannerAdView.BannerSize(320, 50);
    }

    @Override
    void adToView() {
        if (this.mBannerAdView == null) {
            return;
        }
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, this.mBac.getLayoutParams().height);
        this.mBac.addView((View)this.mBannerAdView, (ViewGroup.LayoutParams)params);
    }

    @Override
    public int getRtbProviderId() {
        return this.rtbProviderId;
    }

    @Override
    public Set<AdSize> getSupportedSizes() {
        HashSet<AdSize> sizes = new HashSet<AdSize>();
        sizes.add(AdSize.BANNER_300x250);
        sizes.add(AdSize.BANNER_320x50);
        return sizes;
    }

    @Override
    public void onAdLoad(int providerId) {
        this.rtbProviderId = providerId;
        this.loadSuccess();
    }

    @Override
    public void onAdFailedToLoad(String error) {
        this.failLoad(error);
    }

    @Override
    public void onAdClicked() {
        this.click();
    }
}

