/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.base;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import androidx.annotation.NonNull;
import co.adcel.ads.base.AdIdService;
import co.adcel.ads.base.DeviceUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GoogleApiAvailability;
import java.util.concurrent.Executors;

public class AndroidAdIdService
implements AdIdService {
    private final Context context;
    private String adId;
    private volatile boolean attemptMade = false;

    public AndroidAdIdService(@NonNull Context context) {
        this.context = context;
    }

    @Override
    public void getAdId(final @NonNull AdIdService.AdIdListener listener) {
        if (this.attemptMade) {
            listener.onAdId(this.adId);
            return;
        }
        Executors.newSingleThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                AndroidAdIdService.this.adId = AndroidAdIdService.this.tryGetAdId();
                listener.onAdId(AndroidAdIdService.this.adId);
                AndroidAdIdService.this.attemptMade = true;
            }
        });
    }

    private boolean isGooglePlayServicesAvailable() {
        GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
        int status = googleApiAvailability.isGooglePlayServicesAvailable(this.context);
        return status == 0;
    }

    private static String getAmazonAdId(Context context) {
        try {
            boolean limitAdTracking;
            ContentResolver cr = context.getContentResolver();
            boolean bl = limitAdTracking = Settings.Secure.getInt((ContentResolver)cr, (String)"limit_ad_tracking") != 0;
            if (limitAdTracking) {
                return null;
            }
            return Settings.Secure.getString((ContentResolver)cr, (String)"advertising_id");
        }
        catch (Settings.SettingNotFoundException ex) {
            return null;
        }
    }

    private String tryGetAdId() {
        if (DeviceUtils.isAmazonFireTV(this.context)) {
            return AndroidAdIdService.getAmazonAdId(this.context);
        }
        if (!this.isGooglePlayServicesAvailable()) {
            return null;
        }
        String advertId = null;
        try {
            AdvertisingIdClient.Info idInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.context);
            if (idInfo != null) {
                advertId = idInfo.getId();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return advertId;
    }
}

