/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.base;

import android.net.Uri;
import androidx.annotation.NonNull;
import co.adcel.ads.base.SdkConfigProvider;
import co.adcel.ads.base.WebServiceCallback;
import co.adcel.ads.base.WebServiceError;
import co.adcel.http.Callback;
import co.adcel.http.Error;
import co.adcel.http.HttpClient;
import co.adcel.http.Request;
import co.adcel.http.Response;
import co.adcel.toolkit.Base64Ext;
import co.adcel.toolkit.JsonStringDeserialization;

public abstract class BaseWebService {
    protected static final String API_VERSION = "4";
    protected static final String PATH_SDK = "sdk";
    protected static final String PATH_VER = "v4";
    protected static final String PARAM_PLATFORM = "platform";
    protected static final String PARAM_BUNDLE = "bundle";
    protected static final String PARAM_VERSION = "version";
    protected static final String PARAM_FORMAT = "format";
    protected static final String PARAM_ADID = "adid";
    protected static final String PARAM_GDPR_CONSENT = "gdpr_consent";
    protected static final String HEADER_AUTHORIZATION = "Authorization";
    @NonNull
    private final HttpClient httpClient;
    @NonNull
    private final SdkConfigProvider sdkConfigProvider;

    public BaseWebService(@NonNull HttpClient httpClient, @NonNull SdkConfigProvider sdkConfigProvider) {
        this.httpClient = httpClient;
        this.sdkConfigProvider = sdkConfigProvider;
    }

    @NonNull
    protected final HttpClient getHttpClient() {
        return this.httpClient;
    }

    @NonNull
    protected final void getSdkConfigProvider(@NonNull SdkConfigProvider.Listener listener) {
        this.sdkConfigProvider.get(listener);
    }

    @NonNull
    protected final Uri.Builder createBaseUriBuilder() {
        return new Uri.Builder().scheme("https").authority("rtb.adcel.co").appendPath(PATH_SDK).appendPath(PATH_VER);
    }

    @NonNull
    protected final String getAuthorizationToken(@NonNull String key) {
        return "Basic " + Base64Ext.encode(key);
    }

    protected final <ResponseType> void executeRequest(@NonNull Request request, final @NonNull WebServiceCallback<ResponseType> callback, final @NonNull JsonStringDeserialization<ResponseType> parser) {
        this.httpClient.executeAsync(request, new Callback(){

            @Override
            public void onSuccess(@NonNull Response response) {
                Object parsedResponse = parser.deserialize(response.getText());
                if (parsedResponse != null) {
                    callback.onSuccess(parsedResponse);
                } else {
                    callback.onError(new WebServiceError("Empty response: HTTP Code " + response.getHttpCode()));
                }
            }

            @Override
            public void onError(@NonNull Error error) {
                callback.onError(new WebServiceError(error.getException(), error.getMessage()));
            }
        });
    }
}

