/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.base;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import co.adcel.ads.base.AdIdService;
import co.adcel.ads.base.DeviceUtils;
import co.adcel.ads.base.SdkConfig;
import co.adcel.ads.base.SdkConfigProvider;
import co.adcel.ads.base.SdkPlugin;
import co.adcel.common.Utilities;

public class DefaultSdkConfigProvider
implements SdkConfigProvider {
    private static final String PLATFORM_ANDROID = "android";
    private static final String PLATFORM_ANDROID_TV = "androidtv";
    private static final String PLATFORM_FIRE_TV = "firetv";
    private static final String MANIFEST_KEY_PLUGIN = "adcel.sdk.plugin";
    @NonNull
    private final Context context;
    @NonNull
    private final String key;
    @Nullable
    private final SdkPlugin sdkPlugin;
    @NonNull
    private final AdIdService adIdService;
    @Nullable
    private SdkConfig sdkConfig;

    public DefaultSdkConfigProvider(@NonNull Context context, @NonNull String key, @Nullable SdkPlugin sdkPlugin, @NonNull AdIdService adIdService) {
        this.context = context;
        this.key = key;
        this.sdkPlugin = sdkPlugin;
        this.adIdService = adIdService;
    }

    @Override
    public void get(final @NonNull SdkConfigProvider.Listener listener) {
        if (this.sdkConfig != null) {
            listener.onSdkConfigRetrieved(this.sdkConfig);
            return;
        }
        this.adIdService.getAdId(new AdIdService.AdIdListener(){

            @Override
            public void onAdId(@Nullable String adId) {
                DefaultSdkConfigProvider.this.complete(listener, adId);
            }
        });
    }

    private String getPlatform() {
        if (DeviceUtils.isAmazonFireTV(this.context)) {
            return PLATFORM_FIRE_TV;
        }
        if (DeviceUtils.isGoogleTv(this.context)) {
            return PLATFORM_ANDROID_TV;
        }
        return PLATFORM_ANDROID;
    }

    private String getPlugin() {
        if (DeviceUtils.isAmazonFireTV(this.context)) {
            return SdkPlugin.FIRE_TV.getName();
        }
        if (DeviceUtils.isGoogleTv(this.context)) {
            return SdkPlugin.ANDROID_TV.getName();
        }
        if (this.sdkPlugin != null) {
            return this.sdkPlugin.getName();
        }
        String plugin = SdkPlugin.ANDROID.getName();
        try {
            ApplicationInfo ai = this.context.getPackageManager().getApplicationInfo(this.context.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            plugin = bundle.getString(MANIFEST_KEY_PLUGIN);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return plugin;
    }

    private void complete(@NonNull SdkConfigProvider.Listener listener, @Nullable String adId) {
        this.sdkConfig = new SdkConfig(this.key, this.getPlatform(), this.getPlugin(), "1.12.4", this.context.getPackageName(), adId, Utilities.getInstalledProvidersJson(this.context));
        listener.onSdkConfigRetrieved(this.sdkConfig);
    }
}

