/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.inhouse;

import android.net.Uri;
import androidx.annotation.NonNull;
import co.adcel.ads.base.SdkConfig;
import co.adcel.ads.base.SdkConfigProvider;
import co.adcel.ads.base.WebServiceCallback;
import co.adcel.ads.inhouse.InHouseJsonStringDeserialization;
import co.adcel.ads.inhouse.InHouseRequest;
import co.adcel.ads.inhouse.InHouseResponse;
import co.adcel.ads.inhouse.InHouseWebService;
import co.adcel.ads.mediation.DefaultMediationWebService;
import co.adcel.http.HttpClient;
import co.adcel.http.Request;
import co.adcel.toolkit.JsonStringDeserialization;
import co.adcel.toolkit.RawJsonStringDeserialization;

public class DefaultInHouseWebService
extends DefaultMediationWebService
implements InHouseWebService {
    private static final String PATH_INHOUSE = "inhouse";
    private static final String PARAM_DEVICE_VERSION = "device_version";
    private static final String PARAM_DEVICE_TYPE = "device_type";
    private static final String PARAM_DEVICE_NETWORK = "device_network";

    public DefaultInHouseWebService(@NonNull HttpClient httpClient, @NonNull SdkConfigProvider sdkConfigProvider) {
        super(httpClient, sdkConfigProvider);
    }

    @Override
    public void getInHouse(final @NonNull InHouseRequest request, final @NonNull WebServiceCallback<InHouseResponse> callback) {
        this.getSdkConfigProvider(new SdkConfigProvider.Listener(){

            @Override
            public void onSdkConfigRetrieved(@NonNull SdkConfig sdkConfig) {
                DefaultInHouseWebService.this.executeInHouseRequest(request, sdkConfig, callback, new InHouseJsonStringDeserialization());
            }
        });
    }

    @Override
    public void getInHouseRawString(final @NonNull InHouseRequest request, final @NonNull WebServiceCallback<String> callback) {
        this.getSdkConfigProvider(new SdkConfigProvider.Listener(){

            @Override
            public void onSdkConfigRetrieved(@NonNull SdkConfig sdkConfig) {
                DefaultInHouseWebService.this.executeInHouseRequest(request, sdkConfig, callback, new RawJsonStringDeserialization());
            }
        });
    }

    private <T> void executeInHouseRequest(@NonNull InHouseRequest request, @NonNull SdkConfig sdkConfig, @NonNull WebServiceCallback<T> callback, @NonNull JsonStringDeserialization<T> deserialization) {
        Uri.Builder uriBuilder = this.getUriBuilder(request, sdkConfig, PATH_INHOUSE);
        uriBuilder.appendQueryParameter(PARAM_DEVICE_VERSION, request.getDeviceVersion()).appendQueryParameter(PARAM_DEVICE_NETWORK, request.getDeviceNetwork()).appendQueryParameter(PARAM_DEVICE_TYPE, sdkConfig.getPlatform()).appendQueryParameter("gdpr_consent", request.isGdprConsent() ? "1" : "0");
        String url = uriBuilder.build().toString();
        Request httpRequest = new Request.Builder(url).header("Authorization", this.getAuthorizationToken(sdkConfig.getKey())).build();
        this.executeRequest(httpRequest, callback, deserialization);
    }
}

