/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.inhouse;

import androidx.annotation.Nullable;
import co.adcel.ads.inhouse.InHouseResponse;
import co.adcel.ads.inhouse.InHouseVideoAd;
import co.adcel.inhouse.InHouseAd;
import co.adcel.toolkit.JSONObjectExt;
import co.adcel.toolkit.JsonStringDeserialization;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class InHouseJsonStringDeserialization
implements JsonStringDeserialization<InHouseResponse> {
    private static final String STATUS = "status";
    private static final String MODERATE = "moderate";
    private static final String ADS = "ads";
    private static final String IMAGE = "image";
    private static final String VIDEO = "video";
    private static final String REWARD = "reward";
    private static final String CLICK_ID = "click_id";
    private static final String CLICK_URL = "click_url";
    private static final String IMPRESS_URL = "impress_url";
    private static final String STATIC = "static";
    private static final String CTA = "cta";
    private static final String IMAGE_L = "image_l";
    private static final String IMAGE_P = "image_p";
    private static final String ORIENTATION = "orientation";
    private static final String STORE_COUNTRY = "store_country";
    private static final String STORE_ID = "store_id";
    private static final String CACHABLE = "cacheable";
    private static final String DOWNLOAD = "download";
    private static final String SHOULD_CACHE = "should_cache";
    private static final String SIZE = "size";
    private static final String SKIP_TIMER = "skip_timer";
    private static final String STREAMABLE = "streamable";
    private static final String STREAMING = "streaming";

    @Override
    @Nullable
    public InHouseResponse deserialize(@Nullable String text) {
        if (text == null) {
            return null;
        }
        try {
            JSONObject jsonObject = new JSONObject(text);
            JSONObject adsJson = jsonObject.optJSONObject(ADS);
            return new InHouseResponse(jsonObject.getString(STATUS), jsonObject.optBoolean(MODERATE), this.parseInHouseAds(adsJson), this.parseInHouseVideoAds(adsJson, VIDEO), this.parseInHouseVideoAds(adsJson, REWARD));
        }
        catch (JSONException e) {
            return null;
        }
    }

    private List<InHouseAd> parseInHouseAds(JSONObject jsonObject) {
        ArrayList<InHouseAd> ads = new ArrayList<InHouseAd>();
        if (jsonObject == null) {
            return ads;
        }
        JSONArray adsJson = jsonObject.optJSONArray(IMAGE);
        if (adsJson == null) {
            return ads;
        }
        for (int i = 0; i < adsJson.length(); ++i) {
            JSONObject adJson = adsJson.optJSONObject(i);
            if (adJson == null) continue;
            ads.add(new InHouseAd(JSONObjectExt.optString(adJson, CLICK_ID), JSONObjectExt.optString(adJson, CLICK_URL), JSONObjectExt.optString(adJson, IMPRESS_URL), JSONObjectExt.optString(adJson, STORE_COUNTRY), JSONObjectExt.optString(adJson, STORE_ID), this.parseStatic(adJson.optJSONObject(STATIC))));
        }
        return ads;
    }

    private InHouseAd.Static parseStatic(JSONObject jsonObject) {
        return new InHouseAd.Static(JSONObjectExt.optString(jsonObject, CTA), JSONObjectExt.optString(jsonObject, IMAGE_L), JSONObjectExt.optString(jsonObject, IMAGE_P), JSONObjectExt.optString(jsonObject, ORIENTATION));
    }

    private List<InHouseVideoAd> parseInHouseVideoAds(JSONObject jsonObject, String type) {
        ArrayList<InHouseVideoAd> ads = new ArrayList<InHouseVideoAd>();
        if (jsonObject == null) {
            return ads;
        }
        JSONArray adsJson = jsonObject.optJSONArray(type);
        if (adsJson == null) {
            return ads;
        }
        for (int i = 0; i < adsJson.length(); ++i) {
            JSONObject adJson = adsJson.optJSONObject(i);
            if (adJson == null) continue;
            ads.add(new InHouseVideoAd(JSONObjectExt.optString(adJson, CLICK_ID), JSONObjectExt.optString(adJson, CLICK_URL), JSONObjectExt.optString(adJson, IMPRESS_URL), JSONObjectExt.optString(adJson, STORE_COUNTRY), JSONObjectExt.optString(adJson, STORE_ID), this.parseVideoStatic(adJson.optJSONObject(STATIC)), this.parseVideo(adJson.optJSONObject(VIDEO))));
        }
        return ads;
    }

    private InHouseVideoAd.Static parseVideoStatic(JSONObject jsonObject) {
        return new InHouseVideoAd.Static(JSONObjectExt.optString(jsonObject, CTA), JSONObjectExt.optString(jsonObject, IMAGE_L), JSONObjectExt.optString(jsonObject, IMAGE_P), JSONObjectExt.optString(jsonObject, ORIENTATION), JSONObjectExt.optString(jsonObject, VIDEO));
    }

    private InHouseVideoAd.Video parseVideo(JSONObject jsonObject) {
        return new InHouseVideoAd.Video(jsonObject.optBoolean(CACHABLE), JSONObjectExt.optString(jsonObject, DOWNLOAD), jsonObject.optBoolean(SHOULD_CACHE), jsonObject.optInt(SIZE), jsonObject.optInt(SKIP_TIMER), jsonObject.optBoolean(STREAMABLE), JSONObjectExt.optString(jsonObject, STREAMING));
    }
}

