/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.inhouse;

import androidx.annotation.Nullable;
import co.adcel.inhouse.InHouseAd;
import java.util.Objects;

public class InHouseVideoAd
extends InHouseAd {
    private final Static staticData;
    private final Video video;

    public InHouseVideoAd(@Nullable String clickId, @Nullable String clickUrl, @Nullable String impressUrl, @Nullable String storeCountry, @Nullable String storeId, @Nullable Static staticData, @Nullable Video video) {
        super(clickId, clickUrl, impressUrl, storeCountry, storeId, staticData);
        this.staticData = staticData;
        this.video = video;
    }

    @Override
    @Nullable
    public Static getStaticData() {
        return this.staticData;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InHouseVideoAd that = (InHouseVideoAd)o;
        return Objects.equals(this.staticData, that.staticData) && Objects.equals(this.video, that.video);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.staticData, this.video);
    }

    public static class Video {
        private final boolean cacheable;
        private final String download;
        private final boolean shouldCache;
        private final int size;
        private final int skipTimer;
        private final boolean streamable;
        private final String streaming;

        public Video(boolean cacheable, @Nullable String download, boolean shouldCache, int size, int skipTimer, boolean streamable, @Nullable String streaming) {
            this.cacheable = cacheable;
            this.download = download;
            this.shouldCache = shouldCache;
            this.size = size;
            this.skipTimer = skipTimer;
            this.streamable = streamable;
            this.streaming = streaming;
        }

        public boolean isCacheable() {
            return this.cacheable;
        }

        @Nullable
        public String getDownload() {
            return this.download;
        }

        public boolean isShouldCache() {
            return this.shouldCache;
        }

        public int getSize() {
            return this.size;
        }

        public int getSkipTimer() {
            return this.skipTimer;
        }

        public boolean isStreamable() {
            return this.streamable;
        }

        @Nullable
        public String getStreaming() {
            return this.streaming;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Video video = (Video)o;
            return this.cacheable == video.cacheable && this.shouldCache == video.shouldCache && this.size == video.size && this.skipTimer == video.skipTimer && this.streamable == video.streamable && Objects.equals(this.download, video.download) && Objects.equals(this.streaming, video.streaming);
        }

        public int hashCode() {
            return Objects.hash(this.cacheable, this.download, this.shouldCache, this.size, this.skipTimer, this.streamable, this.streaming);
        }
    }

    public static class Static
    extends InHouseAd.Static {
        private final String video;

        public Static(@Nullable String cta, @Nullable String imageLandscape, @Nullable String imagePortrait, @Nullable String orientation, @Nullable String video) {
            super(cta, imageLandscape, imagePortrait, orientation);
            this.video = video;
        }

        @Nullable
        public String getVideo() {
            return this.video;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Static aStatic = (Static)o;
            return Objects.equals(this.video, aStatic.video);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.video);
        }
    }
}

