/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.mediation;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class AdNetworkConfig {
    private final int id;
    private final String name;
    private Map<String, String> credentials;
    private Map<String, Map<String, String>> credentialsBySizes;
    private Map<String, String> zones;
    private String ecpm;
    private int weight;
    private Options opts;

    private AdNetworkConfig(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public int getWeight() {
        return this.weight;
    }

    @Nullable
    public String getEcpm() {
        return this.ecpm;
    }

    @NonNull
    public Map<String, String> getCredentials() {
        return this.credentials;
    }

    @Nullable
    public Map<String, Map<String, String>> getCredentialsBySizes() {
        return this.credentialsBySizes;
    }

    @Nullable
    public Map<String, String> getZones() {
        return this.zones;
    }

    @NonNull
    public Options getOpts() {
        return this.opts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdNetworkConfig adNetworkConfig = (AdNetworkConfig)o;
        return this.id == adNetworkConfig.id && this.weight == adNetworkConfig.weight && this.name.equals(adNetworkConfig.name) && this.credentials.equals(adNetworkConfig.credentials) && Objects.equals(this.credentialsBySizes, adNetworkConfig.credentialsBySizes) && Objects.equals(this.zones, adNetworkConfig.zones) && Objects.equals(this.ecpm, adNetworkConfig.ecpm) && this.opts.equals(adNetworkConfig.opts);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.credentials, this.credentialsBySizes, this.zones, this.ecpm, this.weight, this.opts);
    }

    public static class Options {
        private final int inactiveTimeout;
        private final int maxShows;

        public Options(int inactiveTimeout, int maxShows) {
            this.inactiveTimeout = inactiveTimeout;
            this.maxShows = maxShows;
        }

        public int getInactiveTimeout() {
            return this.inactiveTimeout;
        }

        public int getMaxShows() {
            return this.maxShows;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Options options = (Options)o;
            return this.inactiveTimeout == options.inactiveTimeout && this.maxShows == options.maxShows;
        }

        public int hashCode() {
            return Objects.hash(this.inactiveTimeout, this.maxShows);
        }
    }

    public static class Builder {
        private final int id;
        private final String name;
        private Map<String, String> credentials;
        private Map<String, Map<String, String>> credentialsBySizes;
        private Map<String, String> zones;
        private String ecpm;
        private int weight;
        private Options opts;

        public Builder(int id, @NonNull String name) {
            this.id = id;
            this.name = name;
            this.credentials = new HashMap<String, String>();
            this.opts = new Options(0, Integer.MAX_VALUE);
        }

        @NonNull
        public Builder credentials(@NonNull Map<String, String> credentials) {
            this.credentials = credentials;
            return this;
        }

        @NonNull
        public Builder credentialsBySizes(@Nullable Map<String, Map<String, String>> credentialsBySizes) {
            this.credentialsBySizes = credentialsBySizes;
            return this;
        }

        @NonNull
        public Builder zones(@Nullable Map<String, String> zones) {
            this.zones = zones;
            return this;
        }

        @NonNull
        public Builder ecpm(@Nullable String ecpm) {
            this.ecpm = ecpm;
            return this;
        }

        @NonNull
        public Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        @NonNull
        public Builder opts(@NonNull Options opts) {
            this.opts = opts;
            return this;
        }

        @NonNull
        public AdNetworkConfig build() {
            AdNetworkConfig adNetworkConfig = new AdNetworkConfig(this.id, this.name);
            adNetworkConfig.credentials = this.credentials;
            adNetworkConfig.credentialsBySizes = this.credentialsBySizes;
            adNetworkConfig.zones = this.zones;
            adNetworkConfig.ecpm = this.ecpm;
            adNetworkConfig.weight = this.weight;
            adNetworkConfig.opts = this.opts;
            return adNetworkConfig;
        }
    }
}

