/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.mediation;

import androidx.annotation.Nullable;
import co.adcel.ads.mediation.AdFormatConfig;
import co.adcel.ads.mediation.AdNetworkConfig;
import co.adcel.ads.mediation.CredentialsResponse;
import co.adcel.ads.mediation.InterstitialAdFormatConfig;
import co.adcel.ads.mediation.RewardAdFormatConfig;
import co.adcel.ads.mediation.RewardSettings;
import co.adcel.toolkit.JSONObjectExt;
import co.adcel.toolkit.JsonStringDeserialization;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CredentialsJsonStringDeserialization
implements JsonStringDeserialization<CredentialsResponse> {
    private static final String STATUS = "status";
    private static final String IS_GDPR_APPLICABLE = "isGDPR_applicable";
    private static final String MODERATE = "moderate";
    private static final String MUTE = "mute";
    private static final String USE_INHOUSE = "use_inhouse";
    private static final String AUDIO = "audio";
    private static final String BANNER = "banner";
    private static final String IMAGE = "image";
    private static final String INTERSTITIAL = "interstitial";
    private static final String NATIVE = "native";
    private static final String REWARD = "reward";
    private static final String VIDEO = "video";
    private static final String CREDENTIALS = "credentials";
    private static final String CREDENTIALS_BY_SIZES = "credentials_by_sizes";
    private static final String PROVIDERS = "providers";
    private static final String ID = "id";
    private static final String WEIGHT = "weight";
    private static final String ECPM = "ecpm";
    private static final String NAME = "name";
    private static final String OPTS = "opts";
    private static final String MAX_SHOWS = "max_shows";
    private static final String INACTIVE_TIMEOUT = "inactive_timeout";
    private static final String SETTINGS = "settings";
    private static final String ZONES = "zones";
    private static final String CACHE_SIZE = "cache_size";
    private static final String NTHREADS0 = "nthreads0";
    private static final String NTHREADS = "nthreads";
    private static final String OPTIONS = "options";
    private static final String CALLBACK_URL = "callback_url";
    private static final String CURRENCY_AMOUNT = "currency_amount";
    private static final String CURRENCY_NAME = "currency_name";

    @Override
    @Nullable
    public CredentialsResponse deserialize(@Nullable String text) {
        if (text == null) {
            return null;
        }
        try {
            JSONObject jsonObject = new JSONObject(text);
            String status = jsonObject.getString(STATUS);
            CredentialsResponse.Builder responseBuilder = new CredentialsResponse.Builder(status).isGDPRApplicable(jsonObject.optBoolean(IS_GDPR_APPLICABLE)).moderate(jsonObject.optBoolean(MODERATE)).mute(jsonObject.optBoolean(MUTE)).useInhouse(jsonObject.optBoolean(USE_INHOUSE)).audioWaterfall(this.parseWaterfall(jsonObject.optJSONObject(AUDIO))).bannerWaterfall(this.parseWaterfall(jsonObject.optJSONObject(BANNER))).imageWaterfall(this.parseInterstitialWaterfall(jsonObject.optJSONObject(IMAGE))).interstitialWaterfall(this.parseInterstitialWaterfall(jsonObject.optJSONObject(INTERSTITIAL))).nativeWaterfall(this.parseWaterfall(jsonObject.optJSONObject(NATIVE))).rewardWaterfall(this.parseRewardWaterfall(jsonObject.optJSONObject(REWARD))).videoWaterfall(this.parseInterstitialWaterfall(jsonObject.optJSONObject(VIDEO)));
            return responseBuilder.build();
        }
        catch (JSONException e) {
            return null;
        }
    }

    private AdFormatConfig parseWaterfall(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        return new AdFormatConfig(jsonObject.optBoolean(USE_INHOUSE), this.parseProviders(jsonObject.optJSONArray(PROVIDERS)));
    }

    private InterstitialAdFormatConfig parseInterstitialWaterfall(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        return new InterstitialAdFormatConfig(jsonObject.optBoolean(USE_INHOUSE), this.parseProviders(jsonObject.optJSONArray(PROVIDERS)), jsonObject.optInt(CACHE_SIZE), jsonObject.optInt(NTHREADS), jsonObject.optInt(NTHREADS0));
    }

    private RewardAdFormatConfig parseRewardWaterfall(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        return new RewardAdFormatConfig(jsonObject.optBoolean(USE_INHOUSE), this.parseProviders(jsonObject.optJSONArray(PROVIDERS)), jsonObject.optInt(CACHE_SIZE), jsonObject.optInt(NTHREADS), jsonObject.optInt(NTHREADS0), this.parseRewardSettings(jsonObject.optJSONObject(SETTINGS)));
    }

    private RewardSettings parseRewardSettings(JSONObject jsonObject) {
        return new RewardSettings(JSONObjectExt.optString(jsonObject, CALLBACK_URL), JSONObjectExt.optString(jsonObject, CURRENCY_AMOUNT), JSONObjectExt.optString(jsonObject, CURRENCY_NAME));
    }

    private List<AdNetworkConfig> parseProviders(JSONArray jsonArray) {
        ArrayList<AdNetworkConfig> adNetworkConfigs = new ArrayList<AdNetworkConfig>();
        if (jsonArray == null) {
            return adNetworkConfigs;
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.optJSONObject(i);
            AdNetworkConfig adNetworkConfig = this.parseProvider(jsonObject);
            if (adNetworkConfig == null) continue;
            adNetworkConfigs.add(adNetworkConfig);
        }
        return adNetworkConfigs;
    }

    private AdNetworkConfig parseProvider(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        try {
            JSONObject jsonCredentials = jsonObject.optJSONObject(CREDENTIALS);
            return new AdNetworkConfig.Builder(jsonObject.optInt(ID), jsonObject.getString(NAME)).credentials(this.parseCredentials(jsonCredentials)).credentialsBySizes(this.parseCredentialsBySizes(jsonCredentials)).zones(this.parseZones(jsonObject.optJSONObject(ZONES))).ecpm(JSONObjectExt.optString(jsonObject, ECPM)).weight(jsonObject.optInt(WEIGHT)).opts(this.parseOptions(jsonObject.optJSONObject(OPTS))).build();
        }
        catch (JSONException e) {
            return null;
        }
    }

    private Map<String, String> parseCredentials(JSONObject jsonObject) {
        HashMap<String, String> credentials = new HashMap<String, String>();
        if (jsonObject == null) {
            return credentials;
        }
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String value;
            String key = (String)keys.next();
            if (key.equals(CREDENTIALS_BY_SIZES) || (value = JSONObjectExt.optString(jsonObject, key)) == null) continue;
            credentials.put(key, value);
        }
        return credentials;
    }

    private Map<String, Map<String, String>> parseCredentialsBySizes(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        JSONObject jsonCredentialsBySizes = jsonObject.optJSONObject(CREDENTIALS_BY_SIZES);
        if (jsonCredentialsBySizes == null) {
            return null;
        }
        HashMap<String, Map<String, String>> credentials = new HashMap<String, Map<String, String>>();
        Iterator keys = jsonCredentialsBySizes.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            JSONObject jsonCredentials = jsonCredentialsBySizes.optJSONObject(key);
            if (jsonCredentials == null) continue;
            credentials.put(key, this.parseCredentials(jsonCredentials));
        }
        return credentials;
    }

    private Map<String, String> parseZones(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        HashMap<String, String> zones = new HashMap<String, String>();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = JSONObjectExt.optString(jsonObject, key);
            if (value == null) continue;
            zones.put(key, value);
        }
        return zones;
    }

    private AdNetworkConfig.Options parseOptions(JSONObject jsonObject) {
        return new AdNetworkConfig.Options(jsonObject.optInt(INACTIVE_TIMEOUT), jsonObject.optInt(MAX_SHOWS, Integer.MAX_VALUE));
    }
}

