/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.mediation;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import co.adcel.ads.base.BaseResponse;
import co.adcel.ads.mediation.AdFormatConfig;
import co.adcel.ads.mediation.InterstitialAdFormatConfig;
import co.adcel.ads.mediation.RewardAdFormatConfig;
import java.util.Objects;

public class CredentialsResponse
extends BaseResponse {
    private boolean isGDPRApplicable;
    private boolean moderate;
    private boolean mute;
    private boolean useInhouse;
    private AdFormatConfig audioAdFormatConfig;
    private AdFormatConfig bannerAdFormatConfig;
    private InterstitialAdFormatConfig imageAdFormatConfig;
    private InterstitialAdFormatConfig interstitialAdFormatConfig;
    private InterstitialAdFormatConfig videoAdFormatConfig;
    private AdFormatConfig nativeAdFormatConfig;
    private RewardAdFormatConfig rewardAdFormatConfig;

    private CredentialsResponse(@NonNull String status) {
        super(status);
    }

    public boolean isGDPRApplicable() {
        return this.isGDPRApplicable;
    }

    public boolean isModerate() {
        return this.moderate;
    }

    public boolean isMute() {
        return this.mute;
    }

    public boolean isUseInhouse() {
        return this.useInhouse;
    }

    @Nullable
    public AdFormatConfig getAudioAdFormatConfig() {
        return this.audioAdFormatConfig;
    }

    @Nullable
    public AdFormatConfig getBannerAdFormatConfig() {
        return this.bannerAdFormatConfig;
    }

    @Nullable
    public InterstitialAdFormatConfig getImageAdFormatConfig() {
        return this.imageAdFormatConfig;
    }

    @Nullable
    public InterstitialAdFormatConfig getInterstitialAdFormatConfig() {
        return this.interstitialAdFormatConfig;
    }

    @Nullable
    public InterstitialAdFormatConfig getVideoAdFormatConfig() {
        return this.videoAdFormatConfig;
    }

    @Nullable
    public AdFormatConfig getNativeAdFormatConfig() {
        return this.nativeAdFormatConfig;
    }

    @Nullable
    public RewardAdFormatConfig getRewardAdFormatConfig() {
        return this.rewardAdFormatConfig;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CredentialsResponse that = (CredentialsResponse)o;
        return this.isGDPRApplicable == that.isGDPRApplicable && this.moderate == that.moderate && this.mute == that.mute && this.useInhouse == that.useInhouse && Objects.equals(this.audioAdFormatConfig, that.audioAdFormatConfig) && Objects.equals(this.bannerAdFormatConfig, that.bannerAdFormatConfig) && Objects.equals(this.imageAdFormatConfig, that.imageAdFormatConfig) && Objects.equals(this.interstitialAdFormatConfig, that.interstitialAdFormatConfig) && Objects.equals(this.videoAdFormatConfig, that.videoAdFormatConfig) && Objects.equals(this.nativeAdFormatConfig, that.nativeAdFormatConfig) && Objects.equals(this.rewardAdFormatConfig, that.rewardAdFormatConfig);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.isGDPRApplicable, this.moderate, this.mute, this.useInhouse, this.audioAdFormatConfig, this.bannerAdFormatConfig, this.imageAdFormatConfig, this.interstitialAdFormatConfig, this.videoAdFormatConfig, this.nativeAdFormatConfig, this.rewardAdFormatConfig);
    }

    public static class Builder {
        private final String status;
        private boolean isGDPRApplicable;
        private boolean moderate;
        private boolean mute;
        private boolean useInhouse;
        private AdFormatConfig audioAdFormatConfig;
        private AdFormatConfig bannerAdFormatConfig;
        private InterstitialAdFormatConfig imageWaterfall;
        private InterstitialAdFormatConfig interstitialWaterfall;
        private InterstitialAdFormatConfig videoWaterfall;
        private AdFormatConfig nativeAdFormatConfig;
        private RewardAdFormatConfig rewardWaterfall;

        public Builder(@NonNull String status) {
            this.status = status;
        }

        @NonNull
        public Builder isGDPRApplicable(boolean isGDPRApplicable) {
            this.isGDPRApplicable = isGDPRApplicable;
            return this;
        }

        @NonNull
        public Builder moderate(boolean moderate) {
            this.moderate = moderate;
            return this;
        }

        @NonNull
        public Builder mute(boolean mute) {
            this.mute = mute;
            return this;
        }

        @NonNull
        public Builder useInhouse(boolean useInhouse) {
            this.useInhouse = useInhouse;
            return this;
        }

        @NonNull
        public Builder audioWaterfall(@Nullable AdFormatConfig audioAdFormatConfig) {
            this.audioAdFormatConfig = audioAdFormatConfig;
            return this;
        }

        @NonNull
        public Builder bannerWaterfall(@Nullable AdFormatConfig bannerAdFormatConfig) {
            this.bannerAdFormatConfig = bannerAdFormatConfig;
            return this;
        }

        @NonNull
        public Builder imageWaterfall(@Nullable InterstitialAdFormatConfig imageWaterfall) {
            this.imageWaterfall = imageWaterfall;
            return this;
        }

        @NonNull
        public Builder interstitialWaterfall(@Nullable InterstitialAdFormatConfig interstitialWaterfall) {
            this.interstitialWaterfall = interstitialWaterfall;
            return this;
        }

        @NonNull
        public Builder videoWaterfall(@Nullable InterstitialAdFormatConfig videoWaterfall) {
            this.videoWaterfall = videoWaterfall;
            return this;
        }

        @NonNull
        public Builder nativeWaterfall(@Nullable AdFormatConfig nativeAdFormatConfig) {
            this.nativeAdFormatConfig = nativeAdFormatConfig;
            return this;
        }

        @NonNull
        public Builder rewardWaterfall(@Nullable RewardAdFormatConfig rewardWaterfall) {
            this.rewardWaterfall = rewardWaterfall;
            return this;
        }

        @NonNull
        public CredentialsResponse build() {
            CredentialsResponse response = new CredentialsResponse(this.status);
            response.isGDPRApplicable = this.isGDPRApplicable;
            response.moderate = this.moderate;
            response.mute = this.mute;
            response.useInhouse = this.useInhouse;
            response.audioAdFormatConfig = this.audioAdFormatConfig;
            response.bannerAdFormatConfig = this.bannerAdFormatConfig;
            response.imageAdFormatConfig = this.imageWaterfall;
            response.interstitialAdFormatConfig = this.interstitialWaterfall;
            response.videoAdFormatConfig = this.videoWaterfall;
            response.nativeAdFormatConfig = this.nativeAdFormatConfig;
            response.rewardAdFormatConfig = this.rewardWaterfall;
            return response;
        }
    }
}

