/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.mediation;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import co.adcel.ads.base.WebServiceCallback;
import co.adcel.ads.base.WebServiceError;
import co.adcel.ads.mediation.AdFormat;
import co.adcel.ads.mediation.CredentialsJsonStringDeserialization;
import co.adcel.ads.mediation.CredentialsRequest;
import co.adcel.ads.mediation.CredentialsResponse;
import co.adcel.ads.mediation.MediationWebService;
import co.adcel.common.Utilities;
import co.adcel.toolkit.ListExt;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class CredentialsService {
    private final int TIMEOUT_SEC = 10;
    private final String PROVIDER_PARAMS = "providerParams";
    @NonNull
    private final WeakReference<Context> conextRef;
    @NonNull
    private final MediationWebService mediationWebService;
    private boolean shouldTryToReload;
    private ScheduledExecutorService worker;
    private ScheduledFuture future;

    public CredentialsService(@NonNull Context context, @NonNull MediationWebService mediationWebService) {
        this.conextRef = new WeakReference<Context>(context);
        this.mediationWebService = mediationWebService;
    }

    public void loadCedentials(final @NonNull AdFormat[] formats, final @Nullable OnCredentialsLoadListener onCredentialsLoadListener) {
        Context context = (Context)this.conextRef.get();
        if (context != null && !Utilities.isNetworkConnected(context)) {
            this.shouldTryToReload = true;
            this.tryReload(formats, onCredentialsLoadListener);
            return;
        }
        this.shouldTryToReload = false;
        List<String> formatList = ListExt.map(Arrays.asList(formats), new ListExt.Mapper<AdFormat, String>(){

            @Override
            @Nullable
            public String map(@NonNull AdFormat source) {
                return source.getName();
            }
        });
        CredentialsRequest request = new CredentialsRequest(formatList.toArray(new String[0]), this.getOpenDate(), this.getClickId());
        this.mediationWebService.getCredentialsRaw(request, new WebServiceCallback<String>(){

            @Override
            public void onSuccess(@NonNull String response) {
                CredentialsService.this.doOnSuccess(response, onCredentialsLoadListener);
            }

            @Override
            public void onError(@NonNull WebServiceError error) {
                CredentialsService.this.doOnError(formats, error, onCredentialsLoadListener);
            }
        });
    }

    private void tryReload(final @NonNull AdFormat[] formats, final @Nullable OnCredentialsLoadListener onCredentialsLoadListener) {
        if (this.worker == null) {
            this.worker = Executors.newSingleThreadScheduledExecutor();
        }
        if (this.future != null) {
            return;
        }
        this.future = this.worker.schedule(new Runnable(){

            @Override
            public void run() {
                CredentialsService.this.future = null;
                if (CredentialsService.this.shouldTryToReload) {
                    CredentialsService.this.loadCedentials(formats, onCredentialsLoadListener);
                }
            }
        }, 10L, TimeUnit.SECONDS);
    }

    private void doOnSuccess(@NonNull String response, @Nullable OnCredentialsLoadListener onCredentialsLoadListener) {
        CredentialsResponse credentialsResponse = new CredentialsJsonStringDeserialization().deserialize(response);
        if (credentialsResponse == null) {
            if (onCredentialsLoadListener != null) {
                onCredentialsLoadListener.onCredentialsLoadFailed("Response is not valid");
            }
            return;
        }
        if (!credentialsResponse.isStatusOk()) {
            if (onCredentialsLoadListener != null) {
                onCredentialsLoadListener.onCredentialsLoadFailed(credentialsResponse.getStatus());
            }
            return;
        }
        Context context = (Context)this.conextRef.get();
        if (context != null) {
            Utilities.saveStringLocalData(context, "providerParams", response);
        }
        if (onCredentialsLoadListener != null) {
            onCredentialsLoadListener.onCredentialsLoaded(credentialsResponse);
        }
    }

    private void doOnError(@NonNull AdFormat[] formats, @NonNull WebServiceError error, @Nullable OnCredentialsLoadListener onCredentialsLoadListener) {
        this.shouldTryToReload = true;
        this.tryReload(formats, onCredentialsLoadListener);
        Context context = (Context)this.conextRef.get();
        if (context == null) {
            if (onCredentialsLoadListener != null) {
                onCredentialsLoadListener.onCredentialsLoadFailed("Initialization error");
            }
            return;
        }
        String jsonString = Utilities.readStringLocalData(context, "providerParams");
        CredentialsResponse credentialsResponse = new CredentialsJsonStringDeserialization().deserialize(jsonString);
        if (credentialsResponse == null) {
            if (onCredentialsLoadListener != null) {
                onCredentialsLoadListener.onCredentialsLoadFailed("No params in cache");
            }
            return;
        }
        if (onCredentialsLoadListener != null) {
            onCredentialsLoadListener.onCredentialsLoaded(credentialsResponse);
        }
    }

    private Date getOpenDate() {
        Context context = (Context)this.conextRef.get();
        if (context == null) {
            return new Date();
        }
        return Utilities.getOpenDate2(context);
    }

    @Nullable
    private String getClickId() {
        Context context = (Context)this.conextRef.get();
        if (context == null) {
            return null;
        }
        String inHouseClickId = Utilities.getInHouseClickId(context);
        if (inHouseClickId != null && inHouseClickId.length() != 0) {
            return inHouseClickId;
        }
        return null;
    }

    public static interface OnCredentialsLoadListener {
        public void onCredentialsLoaded(@NonNull CredentialsResponse var1);

        public void onCredentialsLoadFailed(@NonNull String var1);
    }
}

