/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.mediation;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import co.adcel.ads.base.AdIdService;
import co.adcel.ads.base.AndroidAdIdService;
import co.adcel.ads.base.DefaultSdkConfigProvider;
import co.adcel.ads.base.SdkConfigProvider;
import co.adcel.ads.base.SdkPlugin;
import co.adcel.ads.mediation.CredentialsService;
import co.adcel.ads.mediation.DefaultMediationWebService;
import co.adcel.ads.mediation.DefaultSdkLogDatabaseService;
import co.adcel.ads.mediation.DefaultSdkLogWebService;
import co.adcel.ads.mediation.DependenciesFactory;
import co.adcel.ads.mediation.DeviceStatService;
import co.adcel.ads.mediation.DeviceStatWebService;
import co.adcel.ads.mediation.LogService;
import co.adcel.ads.mediation.MediationWebService;
import co.adcel.ads.mediation.SdkLogDatabaseService;
import co.adcel.ads.mediation.SdkLogWebService;
import co.adcel.ads.mediation.StatService;
import co.adcel.ads.mediation.StatWebService;
import co.adcel.http.HttpClient;
import co.adcel.http.SimpleHttpClient;

public class DefaultDependenciesFactory
implements DependenciesFactory {
    @NonNull
    private final Context context;
    @NonNull
    private final String key;
    @Nullable
    private final SdkPlugin sdkPlugin;
    private volatile AdIdService adIdService;
    private volatile HttpClient httpClient;
    private volatile SdkConfigProvider sdkConfigProvider;
    private volatile MediationWebService mediationWebService;
    private volatile CredentialsService credentialsService;
    private volatile SdkLogDatabaseService sdkLogDatabaseService;
    private volatile SdkLogWebService sdkLogWebService;
    private volatile StatWebService statWebService;
    private volatile StatService statService;
    private volatile LogService logService;
    private static DefaultDependenciesFactory dependenciesFactory;

    public DefaultDependenciesFactory(@NonNull Context context, @NonNull String key, @Nullable SdkPlugin sdkPlugin) {
        dependenciesFactory = this;
        this.context = context;
        this.key = key;
        this.sdkPlugin = sdkPlugin;
    }

    @NonNull
    public Context getContext() {
        return this.context;
    }

    @NonNull
    public String getKey() {
        return this.key;
    }

    @Nullable
    public SdkPlugin getSdkPlugin() {
        return this.sdkPlugin;
    }

    @NonNull
    public AdIdService getAdIdService() {
        if (this.adIdService == null) {
            this.adIdService = new AndroidAdIdService(this.getContext());
        }
        return this.adIdService;
    }

    @NonNull
    public HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = new SimpleHttpClient();
        }
        return this.httpClient;
    }

    @NonNull
    public SdkConfigProvider getSdkConfigProvider() {
        if (this.sdkConfigProvider == null) {
            this.sdkConfigProvider = new DefaultSdkConfigProvider(this.getContext(), this.getKey(), this.getSdkPlugin(), this.getAdIdService());
        }
        return this.sdkConfigProvider;
    }

    @NonNull
    public MediationWebService getMediationWebService() {
        if (this.mediationWebService == null) {
            this.mediationWebService = new DefaultMediationWebService(this.getHttpClient(), this.getSdkConfigProvider());
        }
        return this.mediationWebService;
    }

    @Override
    @NonNull
    public CredentialsService getCredentialsService() {
        if (this.credentialsService == null) {
            this.credentialsService = new CredentialsService(this.getContext(), this.getMediationWebService());
        }
        return this.credentialsService;
    }

    @NonNull
    public SdkLogDatabaseService getSdkLogDatabaseService() {
        if (this.sdkLogDatabaseService == null) {
            this.sdkLogDatabaseService = new DefaultSdkLogDatabaseService(this.getContext());
        }
        return this.sdkLogDatabaseService;
    }

    @NonNull
    public SdkLogWebService getSdkLogWebService() {
        if (this.sdkLogWebService == null) {
            this.sdkLogWebService = new DefaultSdkLogWebService(this.getHttpClient(), this.getSdkConfigProvider());
        }
        return this.sdkLogWebService;
    }

    @NonNull
    public StatWebService getStatWebService() {
        if (this.statWebService == null) {
            this.statWebService = new DeviceStatWebService(this.getHttpClient(), this.getSdkConfigProvider());
        }
        return this.statWebService;
    }

    @Override
    @NonNull
    public StatService getStatService() {
        if (this.statService == null) {
            this.statService = new DeviceStatService(this.getContext(), this.getStatWebService());
        }
        return this.statService;
    }

    @Override
    @NonNull
    public LogService getLogService() {
        if (this.logService == null) {
            this.logService = new LogService(this.getSdkLogWebService(), this.getSdkLogDatabaseService());
        }
        return this.logService;
    }

    @Deprecated
    @Nullable
    public static LogService logService() {
        if (dependenciesFactory == null) {
            return null;
        }
        return dependenciesFactory.getLogService();
    }
}

