/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.mediation;

import android.net.Uri;
import androidx.annotation.NonNull;
import co.adcel.ads.base.BaseWebService;
import co.adcel.ads.base.SdkConfig;
import co.adcel.ads.base.SdkConfigProvider;
import co.adcel.ads.base.WebServiceCallback;
import co.adcel.ads.mediation.CredentialsJsonStringDeserialization;
import co.adcel.ads.mediation.CredentialsRequest;
import co.adcel.ads.mediation.CredentialsResponse;
import co.adcel.ads.mediation.MediationWebService;
import co.adcel.http.HttpClient;
import co.adcel.http.Request;
import co.adcel.toolkit.JsonObjectJsonStringDeserialization;
import co.adcel.toolkit.JsonStringDeserialization;
import co.adcel.toolkit.RawJsonStringDeserialization;
import org.json.JSONObject;

public class DefaultMediationWebService
extends BaseWebService
implements MediationWebService {
    private static final String PATH_CREDENTIALS = "credentials";
    private static final String PARAM_PLUGIN = "plugin";
    private static final String PARAM_OPEN_DATE = "open_date";
    private static final String PARAM_CLICK_ID = "click_id";

    public DefaultMediationWebService(@NonNull HttpClient httpClient, @NonNull SdkConfigProvider sdkConfigProvider) {
        super(httpClient, sdkConfigProvider);
    }

    protected Uri.Builder getUriBuilder(CredentialsRequest request, SdkConfig sdkConfig, String path) {
        Uri.Builder uriBuilder = this.createBaseUriBuilder().appendPath(path).appendQueryParameter("platform", sdkConfig.getPlatform()).appendQueryParameter("bundle", sdkConfig.getBundle()).appendQueryParameter("version", sdkConfig.getVersion()).appendQueryParameter(PARAM_PLUGIN, sdkConfig.getPlugin()).appendQueryParameter(PARAM_OPEN_DATE, request.getOpenDate());
        if (sdkConfig.getAdId() != null) {
            uriBuilder.appendQueryParameter("adid", sdkConfig.getAdId());
        }
        if (request.getClickId() != null) {
            uriBuilder.appendQueryParameter(PARAM_CLICK_ID, request.getClickId());
        }
        for (String format : request.getFormats()) {
            uriBuilder.appendQueryParameter("format", format);
        }
        return uriBuilder;
    }

    @Override
    public void getCredentials(final @NonNull CredentialsRequest request, final @NonNull WebServiceCallback<CredentialsResponse> callback) {
        this.getSdkConfigProvider(new SdkConfigProvider.Listener(){

            @Override
            public void onSdkConfigRetrieved(@NonNull SdkConfig sdkConfig) {
                DefaultMediationWebService.this.executeCredentialsRequest(request, sdkConfig, callback, new CredentialsJsonStringDeserialization());
            }
        });
    }

    @Override
    public void getCredentialsJson(final @NonNull CredentialsRequest request, final @NonNull WebServiceCallback<JSONObject> callback) {
        this.getSdkConfigProvider(new SdkConfigProvider.Listener(){

            @Override
            public void onSdkConfigRetrieved(@NonNull SdkConfig sdkConfig) {
                DefaultMediationWebService.this.executeCredentialsRequest(request, sdkConfig, callback, new JsonObjectJsonStringDeserialization());
            }
        });
    }

    @Override
    public void getCredentialsRaw(final @NonNull CredentialsRequest request, final @NonNull WebServiceCallback<String> callback) {
        this.getSdkConfigProvider(new SdkConfigProvider.Listener(){

            @Override
            public void onSdkConfigRetrieved(@NonNull SdkConfig sdkConfig) {
                DefaultMediationWebService.this.executeCredentialsRequest(request, sdkConfig, callback, new RawJsonStringDeserialization());
            }
        });
    }

    private <T> void executeCredentialsRequest(@NonNull CredentialsRequest request, @NonNull SdkConfig sdkConfig, @NonNull WebServiceCallback<T> callback, @NonNull JsonStringDeserialization<T> deserialization) {
        Uri.Builder uriBuilder = this.getUriBuilder(request, sdkConfig, PATH_CREDENTIALS);
        String url = uriBuilder.build().toString();
        Request httpRequest = new Request.Builder(url).header("Authorization", this.getAuthorizationToken(sdkConfig.getKey())).body(sdkConfig.getInstalledProvidersJsonString()).build();
        this.executeRequest(httpRequest, callback, deserialization);
    }
}

