/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.mediation;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import co.adcel.ads.mediation.LogJsonStringSerialization;
import co.adcel.ads.mediation.SdkLog;
import co.adcel.ads.mediation.SdkLogDatabaseService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DefaultSdkLogDatabaseService
implements SdkLogDatabaseService {
    private static final int LIMIT_TO_SAVE = 500;
    private ExecutorService executorService;
    private SQLiteDatabase db;
    private String databaseCreateError = null;

    public DefaultSdkLogDatabaseService(@NonNull Context context) {
        try {
            DBHelper dbHelper = new DBHelper(context);
            this.db = dbHelper.getWritableDatabase();
        }
        catch (SQLiteException e) {
            this.databaseCreateError = e.getMessage();
        }
    }

    private ExecutorService getDefaultExecutorService() {
        if (this.executorService == null) {
            this.executorService = Executors.newSingleThreadExecutor();
        }
        return this.executorService;
    }

    @Override
    public void save(final @NonNull List<SdkLog> logs, final @Nullable SdkLogDatabaseService.OnSdkLogSaveCallback onSdkLogSaveCallback) {
        this.getDefaultExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                int count;
                Object cv;
                if (DefaultSdkLogDatabaseService.this.db == null) {
                    String error = "database is null";
                    if (DefaultSdkLogDatabaseService.this.databaseCreateError != null) {
                        error = error + ": " + DefaultSdkLogDatabaseService.this.databaseCreateError;
                    }
                    if (onSdkLogSaveCallback != null) {
                        onSdkLogSaveCallback.onSdkLogSaveFailed(error);
                    }
                    return;
                }
                for (SdkLog log : logs) {
                    cv = new ContentValues();
                    String content = new LogJsonStringSerialization().serialize(log);
                    cv.put("content", content);
                    DefaultSdkLogDatabaseService.this.db.insert("log", null, (ContentValues)cv);
                }
                if (onSdkLogSaveCallback != null) {
                    onSdkLogSaveCallback.onSdkLogSaveSuccessed();
                }
                Cursor cur = DefaultSdkLogDatabaseService.this.db.rawQuery("select count(*) from log", null);
                cv = null;
                try {
                    cur.moveToFirst();
                    count = cur.getInt(0);
                }
                catch (Throwable content) {
                    cv = content;
                    throw content;
                }
                finally {
                    if (cur != null) {
                        if (cv != null) {
                            try {
                                cur.close();
                            }
                            catch (Throwable content) {
                                ((Throwable)cv).addSuppressed(content);
                            }
                        } else {
                            cur.close();
                        }
                    }
                }
                if (count > 500) {
                    int limit = count - 500;
                    ArrayList<String> ids = new ArrayList<String>();
                    String query = "select id from log order by id asc limit " + limit;
                    try (Cursor cur2 = DefaultSdkLogDatabaseService.this.db.rawQuery(query, null);){
                        while (cur2.moveToNext()) {
                            ids.add(cur2.getString(cur2.getColumnIndex("id")));
                        }
                    }
                    for (String id : ids) {
                        DefaultSdkLogDatabaseService.this.db.delete("log", "id=?", new String[]{id});
                    }
                }
            }
        });
    }

    @Override
    public void shiftExactly(final int limit, final @Nullable SdkLogDatabaseService.OnSdkLogDataLoadCallback onSdkLogDataLoadCallback) {
        this.getDefaultExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                if (DefaultSdkLogDatabaseService.this.db == null) {
                    String error = "database is null";
                    if (DefaultSdkLogDatabaseService.this.databaseCreateError != null) {
                        error = error + ": " + DefaultSdkLogDatabaseService.this.databaseCreateError;
                    }
                    if (onSdkLogDataLoadCallback != null) {
                        onSdkLogDataLoadCallback.onSdkLogDataLoadFailed(error);
                    }
                    return;
                }
                ArrayList<SdkLog> logs = new ArrayList<SdkLog>();
                ArrayList<String> ids = new ArrayList<String>();
                try (Cursor cur = DefaultSdkLogDatabaseService.this.db.query("log", null, null, null, null, null, null, String.valueOf(limit));){
                    LogJsonStringSerialization serialization = new LogJsonStringSerialization();
                    while (cur.moveToNext()) {
                        try {
                            JSONObject jsonObject = new JSONObject(cur.getString(cur.getColumnIndex("content")));
                            SdkLog sdkLog = serialization.deserialize(jsonObject.toString());
                            logs.add(sdkLog);
                            ids.add(cur.getString(cur.getColumnIndex("id")));
                        }
                        catch (JSONException jSONException) {}
                    }
                }
                catch (Exception e) {
                    if (onSdkLogDataLoadCallback != null) {
                        onSdkLogDataLoadCallback.onSdkLogDataLoadFailed(e.getMessage());
                    }
                    return;
                }
                if (logs.size() < limit) {
                    if (onSdkLogDataLoadCallback != null) {
                        onSdkLogDataLoadCallback.onSdkLogDataLoadFailed("logs count less than " + limit);
                    }
                    return;
                }
                for (String id : ids) {
                    DefaultSdkLogDatabaseService.this.db.delete("log", "id=?", new String[]{id});
                }
                if (onSdkLogDataLoadCallback != null) {
                    onSdkLogDataLoadCallback.onSdkLogDataLoaded(logs);
                }
            }
        });
    }

    private static class DBHelper
    extends SQLiteOpenHelper {
        static final int DB_VERSION = 2;
        static final String TABLE_LOG = "log";
        static final String FIELD_ID = "id";
        static final String FIELD_CONTENT = "content";

        public DBHelper(Context context) {
            super(context, "AdCelLog", null, 2);
        }

        public void onCreate(SQLiteDatabase db) {
            db.execSQL("create table log (id integer primary key autoincrement,content text);");
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            if (oldVersion < 2) {
                JSONArray jsonArr = new JSONArray();
                try (Cursor cur2 = db.query(TABLE_LOG, null, null, null, null, null, null, null);){
                    while (cur2.moveToNext()) {
                        try {
                            JSONArray json = new JSONArray(cur2.getString(cur2.getColumnIndex(FIELD_CONTENT)));
                            for (int i = 0; i < json.length(); ++i) {
                                jsonArr.put(json.get(i));
                                if (jsonArr.length() >= 500) break;
                            }
                            if (jsonArr.length() < 500) continue;
                            break;
                        }
                        catch (JSONException json) {
                        }
                    }
                }
                catch (Exception cur2) {
                    // empty catch block
                }
                db.execSQL("DROP TABLE log;");
                db.execSQL("create table log (id integer primary key autoincrement,content text);");
                for (int i = 0; i < Math.min(jsonArr.length(), 500); ++i) {
                    JSONObject jsonObject = jsonArr.optJSONObject(i);
                    if (jsonObject == null) continue;
                    ContentValues cv = new ContentValues();
                    String content = jsonObject.toString();
                    cv.put(FIELD_CONTENT, content);
                    db.insert(TABLE_LOG, null, cv);
                }
            }
        }
    }
}

