/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.mediation;

import android.net.Uri;
import androidx.annotation.NonNull;
import co.adcel.ads.base.BaseResponse;
import co.adcel.ads.base.BaseWebService;
import co.adcel.ads.base.ResponseJsonStringDeserialization;
import co.adcel.ads.base.SdkConfig;
import co.adcel.ads.base.SdkConfigProvider;
import co.adcel.ads.base.WebServiceCallback;
import co.adcel.ads.mediation.LogRequest;
import co.adcel.ads.mediation.LogRequestJsonStringSerialization;
import co.adcel.ads.mediation.SdkLogWebService;
import co.adcel.http.HttpClient;
import co.adcel.http.Request;

public final class DefaultSdkLogWebService
extends BaseWebService
implements SdkLogWebService {
    private static final String PATH_STAT = "stat";

    public DefaultSdkLogWebService(@NonNull HttpClient httpClient, @NonNull SdkConfigProvider sdkConfigProvider) {
        super(httpClient, sdkConfigProvider);
    }

    @Override
    public void sendLog(final @NonNull LogRequest request, final @NonNull WebServiceCallback<BaseResponse> callback) {
        this.getSdkConfigProvider(new SdkConfigProvider.Listener(){

            @Override
            public void onSdkConfigRetrieved(@NonNull SdkConfig sdkConfig) {
                DefaultSdkLogWebService.this.executeSendLogRequest(request, sdkConfig, callback);
            }
        });
    }

    private void executeSendLogRequest(@NonNull LogRequest request, @NonNull SdkConfig sdkConfig, @NonNull WebServiceCallback<BaseResponse> callback) {
        Uri.Builder uriBuilder = this.createBaseUriBuilder().appendPath(PATH_STAT).appendQueryParameter("platform", sdkConfig.getPlatform()).appendQueryParameter("version", sdkConfig.getVersion()).appendQueryParameter("bundle", sdkConfig.getBundle()).appendQueryParameter("adid", sdkConfig.getAdId());
        String url = uriBuilder.build().toString();
        String body = new LogRequestJsonStringSerialization().serialize(request);
        Request httpRequest = new Request.Builder(url).method(Request.Method.PUT).body(body).build();
        this.executeRequest(httpRequest, callback, new ResponseJsonStringDeserialization());
    }
}

