/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.mediation;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.location.Location;
import android.location.LocationManager;
import android.os.Build;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import co.adcel.ads.mediation.StatRequest;
import co.adcel.ads.mediation.StatService;
import co.adcel.ads.mediation.StatWebService;

public class DeviceStatService
implements StatService {
    private final Context context;
    private final StatWebService statWebService;

    public DeviceStatService(@NonNull Context context, @NonNull StatWebService statWebService) {
        this.context = context;
        this.statWebService = statWebService;
    }

    @Override
    public void send() {
        String packageName = this.context.getApplicationContext().getPackageName();
        String androidId = Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id");
        DisplayMetrics displayMetrics = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)this.context.getSystemService("window");
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        int height = displayMetrics.heightPixels;
        int width = displayMetrics.widthPixels;
        int density = displayMetrics.densityDpi;
        String manufacturer = Build.MANUFACTURER;
        String model = Build.MODEL;
        StatRequest.Builder requestBuilder = new StatRequest.Builder().androidId(androidId).height(height).width(width).density(density).manufacturer(manufacturer).model(model);
        this.addLatLon(requestBuilder, packageName);
        this.statWebService.sendStat(requestBuilder.build());
    }

    private void addLatLon(StatRequest.Builder requestBuilder, String packageName) {
        try {
            boolean hasPerm;
            PackageManager pm = this.context.getPackageManager();
            if (pm == null) {
                return;
            }
            int perm = pm.checkPermission("android.permission.ACCESS_FINE_LOCATION", packageName);
            boolean bl = hasPerm = perm == 0;
            if (!hasPerm) {
                return;
            }
            LocationManager lm = (LocationManager)this.context.getSystemService("location");
            Location location = lm.getLastKnownLocation("gps");
            if (location == null) {
                return;
            }
            requestBuilder.lat(location.getLatitude());
            requestBuilder.lon(location.getLongitude());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

