/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.mediation;

import android.net.Uri;
import androidx.annotation.NonNull;
import co.adcel.ads.base.BaseWebService;
import co.adcel.ads.base.SdkConfig;
import co.adcel.ads.base.SdkConfigProvider;
import co.adcel.ads.mediation.StatRequest;
import co.adcel.ads.mediation.StatWebService;
import co.adcel.http.HttpClient;
import co.adcel.http.Request;

public final class DeviceStatWebService
extends BaseWebService
implements StatWebService {
    private static final String PATH_STAT = "stat";
    private static final String PARAM_S_HEIGHT = "s.height";
    private static final String PARAM_S_WIDTH = "s.width";
    private static final String PARAM_S_DENSITY = "s.density";
    private static final String PARAM_S_ADID = "s.adid";
    private static final String PARAM_S_ANDROIDID = "s.androidid";
    private static final String PARAM_S_MANUFACTURER = "s.manufaturer";
    private static final String PARAM_S_MODEL = "s.model";
    private static final String PARAM_S_LAT = "s.lat";
    private static final String PARAM_S_LON = "s.lon";

    public DeviceStatWebService(@NonNull HttpClient httpClient, @NonNull SdkConfigProvider sdkConfigProvider) {
        super(httpClient, sdkConfigProvider);
    }

    @Override
    public void sendStat(final @NonNull StatRequest request) {
        this.getSdkConfigProvider(new SdkConfigProvider.Listener(){

            @Override
            public void onSdkConfigRetrieved(@NonNull SdkConfig sdkConfig) {
                DeviceStatWebService.this.executeStatRequest(request, sdkConfig);
            }
        });
    }

    private void executeStatRequest(@NonNull StatRequest request, @NonNull SdkConfig sdkConfig) {
        Uri.Builder uriBuilder = this.createBaseUriBuilder().appendPath(PATH_STAT).appendQueryParameter("platform", sdkConfig.getPlatform()).appendQueryParameter("bundle", sdkConfig.getBundle()).appendQueryParameter(PARAM_S_HEIGHT, String.valueOf(request.getHeight())).appendQueryParameter(PARAM_S_WIDTH, String.valueOf(request.getWidth())).appendQueryParameter(PARAM_S_DENSITY, String.valueOf(request.getDensity()));
        if (sdkConfig.getAdId() != null) {
            uriBuilder.appendQueryParameter(PARAM_S_ADID, sdkConfig.getAdId());
            uriBuilder.appendQueryParameter("adid", sdkConfig.getAdId());
        }
        if (request.getAndroidId() != null) {
            uriBuilder.appendQueryParameter(PARAM_S_ANDROIDID, request.getAndroidId());
        }
        if (request.getManufacturer() != null) {
            uriBuilder.appendQueryParameter(PARAM_S_MANUFACTURER, request.getManufacturer());
        }
        if (request.getModel() != null) {
            uriBuilder.appendQueryParameter(PARAM_S_MODEL, request.getModel());
        }
        if (request.getLat() != null) {
            uriBuilder.appendQueryParameter(PARAM_S_LAT, String.valueOf(request.getLat()));
        }
        if (request.getLon() != null) {
            uriBuilder.appendQueryParameter(PARAM_S_LON, String.valueOf(request.getLon()));
        }
        String url = uriBuilder.build().toString();
        Request httpRequest = new Request.Builder(url).method(Request.Method.PUT).build();
        this.getHttpClient().executeAsync(httpRequest);
    }
}

