/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.mediation;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import co.adcel.ads.mediation.SdkLog;
import co.adcel.toolkit.JSONObjectExt;
import co.adcel.toolkit.JsonStringDeserialization;
import co.adcel.toolkit.JsonStringSerialization;
import org.json.JSONException;
import org.json.JSONObject;

public class LogJsonStringSerialization
implements JsonStringSerialization<SdkLog>,
JsonStringDeserialization<SdkLog> {
    @Override
    @NonNull
    public String serialize(@NonNull SdkLog sdkLog) {
        try {
            JSONObject jsonError = new JSONObject();
            JSONObject json = new JSONObject();
            jsonError.put("code", sdkLog.getErrorCode());
            jsonError.put("text", (Object)sdkLog.getErrorText());
            json.put("provider_id", sdkLog.getProviderId());
            if (sdkLog.getRtbProviderId() > 0) {
                json.put("rtb_provider_id", sdkLog.getRtbProviderId());
            }
            json.put("waterfall_index", sdkLog.getWaterfallIndex());
            if (sdkLog.isClicked()) {
                json.put("clicked", sdkLog.isClicked());
            } else {
                json.put("ok", sdkLog.isOK());
            }
            json.put("ts", sdkLog.getTimestamp());
            json.put("sk", (Object)sdkLog.getSk());
            json.put("format", (Object)sdkLog.getFormat());
            if (sdkLog.getZone() != null) {
                json.put("zone", (Object)sdkLog.getZone());
            }
            json.put("id", (Object)sdkLog.getSessionId());
            json.put("error", (Object)jsonError);
            json.put("st", sdkLog.getSessionTime());
            return json.toString();
        }
        catch (JSONException ignored) {
            return new JSONObject().toString();
        }
    }

    @Override
    @Nullable
    public SdkLog deserialize(@Nullable String text) {
        if (text == null) {
            return null;
        }
        try {
            JSONObject jsonObject = new JSONObject(text);
            return this.parseSdkLog(jsonObject);
        }
        catch (JSONException e) {
            return null;
        }
    }

    private SdkLog parseSdkLog(JSONObject jsonObject) {
        SdkLog.Builder builder = new SdkLog.Builder().sessionId(JSONObjectExt.optString(jsonObject, "id")).providerId(jsonObject.optInt("provider_id")).rtbProviderId(jsonObject.optInt("rtb_provider_id")).waterfallIndex(jsonObject.optInt("waterfall_index")).isClicked(jsonObject.optBoolean("clicked")).isOK(jsonObject.optBoolean("ok")).format(JSONObjectExt.optString(jsonObject, "format")).zone(JSONObjectExt.optString(jsonObject, "zone")).sessionTime(jsonObject.optInt("st"));
        JSONObject jsonError = jsonObject.optJSONObject("error");
        if (jsonError != null) {
            builder.errorCode(jsonError.optInt("code"));
            builder.errorText(JSONObjectExt.optString(jsonError, "text"));
        }
        return builder.build();
    }
}

