/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.mediation;

import androidx.annotation.NonNull;
import co.adcel.ads.base.BaseResponse;
import co.adcel.ads.base.WebServiceCallback;
import co.adcel.ads.base.WebServiceError;
import co.adcel.ads.mediation.LogRequest;
import co.adcel.ads.mediation.SdkLog;
import co.adcel.ads.mediation.SdkLogDatabaseService;
import co.adcel.ads.mediation.SdkLogWebService;
import co.adcel.logger.AdsATALog;
import java.util.Collections;
import java.util.List;

public final class LogService {
    public static final int ERROR_PROVIDER_CACHING_NOT_STARTED = 72411;
    public static final int ERROR_PROVIDER_CACHING_NOT_FINISHED = 72412;
    public static final int ERROR_PROVIDER_CACHING_TIMED_OUT = 72413;
    public static final int ERROR_PROVIDER_NOT_SHOWN = 72414;
    public static final int ERROR_PROVIDER_INTERNAL = 72415;
    public static final int ERROR_PROVIDER_EMPTY_QUEUE = 72416;
    public static final int ERROR_SDK_NOT_STARTED = 72417;
    public static final int ERROR_PROVIDER_NOT_INITIALIZED = 72418;
    public static final int PSEUDOERROR_BANNER_LOAD = 92785;
    public static final int PSEUDOERROR_BANNER_FAILED_TO_LOAD = 92786;
    public static final int ERROR_SDK_SESSION = 73628;
    public static final int WF_INDEX_ALL_PROVIDERS_FAILED_WILL_RETRY = -1;
    public static final int WF_INDEX_ALL_PROVIDERS_FAILED_AFTER_RETRY = -2;
    public static final int WF_INDEX_PROVIDER_FAILED_TO_INITIALIZE = -3;
    public static final int WF_SESSION = -91;
    private static final int LIMIT_TO_SEND = 50;
    @NonNull
    private final SdkLogWebService sdkLogWebService;
    @NonNull
    private final SdkLogDatabaseService sdkLogDatabaseService;
    private volatile boolean isRetryInProgress;

    public LogService(@NonNull SdkLogWebService sdkLogWebService, @NonNull SdkLogDatabaseService sdkLogDatabaseService) {
        this.sdkLogWebService = sdkLogWebService;
        this.sdkLogDatabaseService = sdkLogDatabaseService;
    }

    public void send(SdkLog sdkLog) {
        final List<SdkLog> logs = Collections.singletonList(sdkLog);
        this.sdkLogDatabaseService.save(logs, new SdkLogDatabaseService.OnSdkLogSaveCallback(){

            @Override
            public void onSdkLogSaveSuccessed() {
                AdsATALog.d("AdCelSDK Log was added to queue");
                LogService.this.tryResendRequest();
            }

            @Override
            public void onSdkLogSaveFailed(@NonNull String error) {
                AdsATALog.d("AdCelSDK Log upload start");
                LogService.this.upload(logs);
            }
        });
    }

    private void upload(final @NonNull List<SdkLog> logs) {
        LogRequest request = new LogRequest(logs);
        this.sdkLogWebService.sendLog(request, new WebServiceCallback<BaseResponse>(){

            @Override
            public void onSuccess(@NonNull BaseResponse response) {
                LogService.this.isRetryInProgress = false;
            }

            @Override
            public void onError(@NonNull WebServiceError error) {
                LogService.this.isRetryInProgress = false;
                LogService.this.sdkLogDatabaseService.save(logs, null);
            }
        });
    }

    private void tryResendRequest() {
        if (this.isRetryInProgress) {
            return;
        }
        this.isRetryInProgress = true;
        this.sdkLogDatabaseService.shiftExactly(50, new SdkLogDatabaseService.OnSdkLogDataLoadCallback(){

            @Override
            public void onSdkLogDataLoaded(@NonNull List<SdkLog> logs) {
                LogService.this.upload(logs);
            }

            @Override
            public void onSdkLogDataLoadFailed(String error) {
                LogService.this.isRetryInProgress = false;
                AdsATALog.e("AdCelSDK Log: " + error);
            }
        });
    }
}

