/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.mediation;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import co.adcel.ads.mediation.AdFormat;
import co.adcel.ads.mediation.CredentialsResponse;
import co.adcel.ads.mediation.CredentialsService;
import co.adcel.ads.mediation.MediationContext;
import co.adcel.ads.mediation.SessionLoggerService;
import co.adcel.ads.mediation.StatService;
import co.adcel.common.GDPRUserConsent;
import co.adcel.common.TypeConverter;
import co.adcel.common.Utilities;
import co.adcel.inhouse.AdCelInHouse;
import co.adcel.init.AdCel;
import co.adcel.init.AdCelInitializationListener;
import co.adcel.interstitialads.InterstitialAdProviderPopulateBase;
import co.adcel.interstitialads.rewarded.RewardedAdProviderPopulateBase;
import co.adcel.interstitialads.video.VideoAdProviderPopulate;
import co.adcel.logger.AdsATALog;

public final class Mediation {
    private final AdCel adcel;
    @NonNull
    private final CredentialsService credentialsService;
    @NonNull
    private final StatService statService;
    @NonNull
    private final SessionLoggerService sessionLoggerService;
    private volatile boolean isInitializtionStarted;
    private volatile boolean isStatSent;
    private AdCelInitializationListener listener;

    public Mediation(@NonNull AdCel adcel, @NonNull CredentialsService credentialsService, @NonNull StatService statService, @NonNull SessionLoggerService sessionLoggerService) {
        this.adcel = adcel;
        this.credentialsService = credentialsService;
        this.statService = statService;
        this.sessionLoggerService = sessionLoggerService;
    }

    public void setInitializationListener(AdCelInitializationListener listener) {
        this.listener = listener;
    }

    public void init(Activity activity, final int adTypeMask, final boolean startCachingImmediately) {
        if (this.isInitializtionStarted) {
            return;
        }
        this.isInitializtionStarted = true;
        if (!Utilities.checkBasePermissions(activity)) {
            return;
        }
        this.adcel.getMediationContext().setIsWaterFallInitialized(false);
        this.adcel.getMediationContext().setIsModerated(false);
        this.adcel.getMediationContext().isInHouseUsed(false);
        AdFormat[] typeList = TypeConverter.getAdTypeListFromMask(adTypeMask);
        this.credentialsService.loadCedentials(typeList, new CredentialsService.OnCredentialsLoadListener(){

            @Override
            public void onCredentialsLoaded(@NonNull CredentialsResponse credentialsResponse) {
                Mediation.this.onCredentialsLoaded(adTypeMask, startCachingImmediately, credentialsResponse);
            }

            @Override
            public void onCredentialsLoadFailed(@NonNull String error) {
                Mediation.this.onCredentialsLoadFailed(adTypeMask, error);
            }
        });
    }

    public void onCredentialsLoaded(int adTypeMask, boolean startCachingImmediately, @NonNull CredentialsResponse credentialsResponse) {
        this.isInitializtionStarted = false;
        Context context = this.adcel.getMediationContext().getContext();
        if (context != null) {
            Utilities.findAndRemoveInHouseClickId(context);
        }
        boolean isInHouseUsed = credentialsResponse.isUseInhouse();
        AdsATALog.i("use_inhouse: " + isInHouseUsed);
        this.adcel.getMediationContext().isInHouseUsed(isInHouseUsed);
        Activity activity = this.adcel.getMediationContext().getActivity();
        if (activity != null && isInHouseUsed) {
            AdCelInHouse.initializeSDK(activity, this.adcel.getMediationContext().getSdkKey(), adTypeMask, this.adcel.getMediationContext().getGdprUserConsent() != GDPRUserConsent.NOT_CONSENT);
        }
        this.adcel.getMediationContext().setIsWaterFallInitialized(true);
        this.adcel.getMediationContext().setIsModerated(credentialsResponse.isModerate());
        this.onLoad(credentialsResponse, startCachingImmediately);
        if ((adTypeMask & 0x10) == 16) {
            this.adcel.getMediationContext().getNativeAdsManager().notifyNativeLoad();
        }
        if (this.listener != null) {
            this.listener.onInitializationSuccess(adTypeMask);
        }
    }

    public void onCredentialsLoadFailed(int adTypeMask, @NonNull String error) {
        this.isInitializtionStarted = false;
        AdsATALog.i("WARNING: " + error);
        if ((adTypeMask & 0x10) == 16) {
            this.adcel.getMediationContext().getNativeAdsManager().notifyNativeLoadFail(error);
        }
        if (this.listener != null) {
            this.listener.onInitializationFail(adTypeMask);
        }
    }

    private void onLoad(CredentialsResponse credentialsResponse, boolean startCachingImmediately) {
        boolean hasBanner;
        boolean hasNative;
        boolean hasRewarded;
        boolean hasImage;
        boolean hasVideo;
        boolean hasInterstitial;
        this.sendStat();
        MediationContext aContext = this.adcel.getMediationContext();
        aContext.prepareProviders(credentialsResponse);
        boolean bl = hasInterstitial = credentialsResponse.getInterstitialAdFormatConfig() != null;
        if (hasInterstitial) {
            this.adcel.getMediationContext().getInterstitialAdsManager().createProviderPriorityLists("interstitial", new InterstitialAdProviderPopulateBase(aContext, "interstitial"), startCachingImmediately);
        }
        boolean bl2 = hasVideo = credentialsResponse.getVideoAdFormatConfig() != null;
        if (hasVideo) {
            this.adcel.getMediationContext().getVideoAdsManager().createProviderPriorityLists("video", new VideoAdProviderPopulate(aContext, "video"), startCachingImmediately);
        }
        boolean bl3 = hasImage = credentialsResponse.getImageAdFormatConfig() != null;
        if (hasImage) {
            this.adcel.getMediationContext().getImageAdsManager().createProviderPriorityLists("image", new InterstitialAdProviderPopulateBase(aContext, "image"), startCachingImmediately);
        }
        boolean bl4 = hasRewarded = credentialsResponse.getRewardAdFormatConfig() != null;
        if (hasRewarded) {
            this.adcel.getMediationContext().getRewardedAdsManager().createProviderPriorityLists("reward", new RewardedAdProviderPopulateBase(aContext, "reward"), startCachingImmediately);
        }
        boolean bl5 = hasNative = credentialsResponse.getNativeAdFormatConfig() != null;
        if (hasNative) {
            this.adcel.getMediationContext().getNativeAdsManager().createProviderPriorityList();
        }
        boolean bl6 = hasBanner = credentialsResponse.getBannerAdFormatConfig() != null;
        if (hasBanner) {
            this.adcel.getMediationContext().getBannerAdsManager().createProviderPriorityList();
        }
    }

    private void sendStat() {
        MediationContext aContext = this.adcel.getMediationContext();
        if (this.isStatSent || aContext.isGDPRApplicable() && aContext.getGdprUserConsent() == GDPRUserConsent.NOT_CONSENT) {
            return;
        }
        this.statService.send();
        this.isStatSent = true;
    }

    public void resumeSession() {
        this.sessionLoggerService.resumeSession();
    }

    public void pauseSession() {
        this.sessionLoggerService.pauseSession();
    }
}

