/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.mediation;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import co.adcel.adbanner.BannerAdsManager;
import co.adcel.ads.mediation.CredentialsResponse;
import co.adcel.ads.mediation.RewardAdFormatConfig;
import co.adcel.ads.mediation.RewardSettings;
import co.adcel.ads.mediation.SessionIdGenerator;
import co.adcel.common.AdProviderConverter;
import co.adcel.common.AdProviderDTO;
import co.adcel.common.CacheSettings;
import co.adcel.common.GDPRUserConsent;
import co.adcel.init.AdCel;
import co.adcel.interstitialads.InterstitialAdsManager;
import co.adcel.interstitialads.InterstitialListener;
import co.adcel.interstitialads.rewarded.RewardedAdValues;
import co.adcel.nativeads.NativeAdsManager;
import co.adcel.nativeads.OnNativeAdsAvailabilityListener;
import co.adcel.toolkit.ListExt;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MediationContext {
    private WeakReference<Activity> contextRef = new WeakReference<Object>(null);
    private String adcelSdkKey;
    private InterstitialAdsManager interstitialAdsManager;
    private InterstitialAdsManager imageAdsManager;
    private InterstitialAdsManager videoAdsManager;
    private InterstitialAdsManager rewardedAdsManager;
    private NativeAdsManager nativeAdsManager;
    private BannerAdsManager bannerAdsManager;
    private InterstitialListener interstitialListener;
    private OnNativeAdsAvailabilityListener onNativeAdsAvailabilityListener;
    private List<ProviderItem> providersList;
    private Map<String, List<String>> providersQueues;
    private Map<String, String> targetingParams;
    private Map<String, List<String>> disabledProviders;
    private Map<String, CacheSettings> waterfallCacheSettings;
    private Boolean isWaterFallInitialized = false;
    private Boolean isModerated = false;
    private Boolean isInHouseUsed = false;
    private RewardedAdValues currencySettings = new RewardedAdValues("", "0");
    private boolean isGDPRApplicable = false;
    private GDPRUserConsent gdprUserConsent = GDPRUserConsent.UNDEFINED;
    private boolean mute = false;

    public MediationContext(AdCel adcel) {
        if (adcel == null) {
            throw new IllegalArgumentException("AdCel can't be null");
        }
        this.interstitialAdsManager = new InterstitialAdsManager(this);
        this.imageAdsManager = new InterstitialAdsManager(this);
        this.videoAdsManager = new InterstitialAdsManager(this);
        this.rewardedAdsManager = new InterstitialAdsManager(this);
        this.nativeAdsManager = new NativeAdsManager(this);
        this.bannerAdsManager = new BannerAdsManager(this);
        this.providersList = new ArrayList<ProviderItem>();
        this.providersQueues = new HashMap<String, List<String>>();
        this.targetingParams = new HashMap<String, String>();
        this.disabledProviders = new HashMap<String, List<String>>();
        this.waterfallCacheSettings = new HashMap<String, CacheSettings>();
    }

    public InterstitialAdsManager getInterstitialAdsManager() {
        return this.interstitialAdsManager;
    }

    public InterstitialAdsManager getImageAdsManager() {
        return this.imageAdsManager;
    }

    public InterstitialAdsManager getVideoAdsManager() {
        return this.videoAdsManager;
    }

    public InterstitialAdsManager getRewardedAdsManager() {
        return this.rewardedAdsManager;
    }

    public NativeAdsManager getNativeAdsManager() {
        return this.nativeAdsManager;
    }

    public BannerAdsManager getBannerAdsManager() {
        return this.bannerAdsManager;
    }

    public void setInterstitialListener(InterstitialListener interstitialListener) {
        this.interstitialListener = interstitialListener;
    }

    public InterstitialListener getInterstitialListener() {
        return this.interstitialListener;
    }

    public void setOnNativeAdsAvailabilityListener(OnNativeAdsAvailabilityListener onNativeAdsAvailabilityListener) {
        this.onNativeAdsAvailabilityListener = onNativeAdsAvailabilityListener;
    }

    public OnNativeAdsAvailabilityListener getOnNativeAdsAvailabilityListener() {
        return this.onNativeAdsAvailabilityListener;
    }

    public void setContext(Activity activity) {
        this.contextRef = new WeakReference<Activity>(activity);
    }

    @Nullable
    public Activity getActivity() {
        return (Activity)this.contextRef.get();
    }

    @Nullable
    public Context getContext() {
        return (Context)this.contextRef.get();
    }

    public String getSdkKey() {
        return this.adcelSdkKey;
    }

    public void setSdkKey(String adcelSdkKey) {
        this.adcelSdkKey = adcelSdkKey;
    }

    public void prepareProviders(CredentialsResponse credentialsResponse) {
        this.isGDPRApplicable = credentialsResponse.isGDPRApplicable();
        this.mute = credentialsResponse.isMute();
        AdProviderConverter parser = new AdProviderConverter(this);
        parser.convert(credentialsResponse);
        RewardAdFormatConfig rewardAdFormatConfig = credentialsResponse.getRewardAdFormatConfig();
        if (rewardAdFormatConfig != null) {
            RewardSettings rewardSettings = rewardAdFormatConfig.getSettings();
            this.currencySettings = new RewardedAdValues(rewardSettings.getCurrencyName(), rewardSettings.getCurrencyAmount());
        }
    }

    public RewardedAdValues getCurrencySettings() {
        return this.currencySettings;
    }

    public Map<String, List<String>> getProvidersQueues() {
        return this.providersQueues;
    }

    public String generateSessionId(final String type) {
        List<String> providers = this.getProvidersQueues().get(type);
        if (providers == null) {
            return "";
        }
        List<Integer> ids = ListExt.map(providers, new ListExt.Mapper<String, Integer>(){

            @Override
            @Nullable
            public Integer map(@NonNull String source) {
                AdProviderDTO providerDTO = MediationContext.this.getProvider(source, type);
                if (providerDTO == null) {
                    return null;
                }
                return Integer.parseInt(providerDTO.getProviderId());
            }
        });
        return SessionIdGenerator.generateSessionId(ids);
    }

    public void putProvider(String name, String type, AdProviderDTO provider) {
        Map<String, AdProviderDTO> p = null;
        for (ProviderItem pi : this.providersList) {
            if (pi.name != name) continue;
            p = pi.types;
            break;
        }
        if (p == null) {
            p = new HashMap<String, AdProviderDTO>();
            ProviderItem pi = new ProviderItem();
            pi.name = name;
            pi.types = p;
            this.providersList.add(pi);
        }
        p.put(type, provider);
    }

    public Map<String, AdProviderDTO> getProvider(String name) {
        Map<String, AdProviderDTO> p = null;
        for (ProviderItem pi : this.providersList) {
            if (pi.name != name) continue;
            p = pi.types;
            break;
        }
        if (p != null) {
            return p;
        }
        return null;
    }

    public AdProviderDTO getProvider(String name, String type) {
        Map<String, AdProviderDTO> p = null;
        for (ProviderItem pi : this.providersList) {
            if (pi.name != name) continue;
            p = pi.types;
            break;
        }
        if (p != null) {
            return (AdProviderDTO)p.get(type);
        }
        return null;
    }

    public void setTargetingParam(String name, String value) {
        this.targetingParams.put(name, value);
    }

    public String getTargetingParam(String name) {
        return this.targetingParams.get(name);
    }

    public Map<String, String> getTargetingParams() {
        return this.targetingParams;
    }

    public void disableProvider(String type, String provider) {
        List<String> providers = this.disabledProviders.get(type);
        if (providers == null) {
            providers = new ArrayList<String>();
            this.disabledProviders.put(type, providers);
        }
        if (!providers.contains(provider)) {
            providers.add(provider);
        }
    }

    public boolean isProviderDisabled(String type, String provider) {
        List<String> providers = this.disabledProviders.get(type);
        if (providers == null) {
            return false;
        }
        return providers.contains(provider);
    }

    public boolean isWaterFallInitialized() {
        return this.isWaterFallInitialized;
    }

    public void setIsWaterFallInitialized(Boolean isWaterFallInitialized) {
        this.isWaterFallInitialized = isWaterFallInitialized;
    }

    public boolean isModerated() {
        return this.isModerated;
    }

    public void setIsModerated(Boolean isModerated) {
        this.isModerated = isModerated;
    }

    public Boolean isInHouseUsed() {
        return this.isInHouseUsed;
    }

    public void isInHouseUsed(Boolean isInHouseUsed) {
        this.isInHouseUsed = isInHouseUsed;
    }

    public void setUserConsent(boolean userConsent) {
        this.gdprUserConsent = userConsent ? GDPRUserConsent.CONSENT : GDPRUserConsent.NOT_CONSENT;
    }

    public boolean isGDPRApplicable() {
        return this.isGDPRApplicable && this.gdprUserConsent != GDPRUserConsent.UNDEFINED;
    }

    public GDPRUserConsent getGdprUserConsent() {
        return this.gdprUserConsent;
    }

    public Map<String, CacheSettings> getWaterfallCacheSettings() {
        return this.waterfallCacheSettings;
    }

    public boolean isMute() {
        return this.mute;
    }

    public static class ProviderItem {
        String name;
        Map<String, AdProviderDTO> types;
    }
}

