/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.mediation;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import co.adcel.toolkit.Cryptography;
import java.util.Date;

public class SdkLog {
    private int errorCode;
    private String errorText;
    private int providerId;
    private int rtbProviderId;
    private int waterfallIndex;
    private boolean isClicked;
    private boolean isOK;
    private long timestamp;
    private String sk;
    private String format;
    private String zone;
    private String sessionId;
    private long sessionTime;

    private SdkLog() {
    }

    int getErrorCode() {
        return this.errorCode;
    }

    @Nullable
    String getErrorText() {
        return this.errorText;
    }

    int getProviderId() {
        return this.providerId;
    }

    int getRtbProviderId() {
        return this.rtbProviderId;
    }

    int getWaterfallIndex() {
        return this.waterfallIndex;
    }

    boolean isClicked() {
        return this.isClicked;
    }

    boolean isOK() {
        return this.isOK;
    }

    long getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    String getSk() {
        return this.sk;
    }

    @Nullable
    String getFormat() {
        return this.format;
    }

    @Nullable
    String getZone() {
        return this.zone;
    }

    @Nullable
    String getSessionId() {
        return this.sessionId;
    }

    long getSessionTime() {
        return this.sessionTime;
    }

    public static class Builder {
        private int errorCode;
        private String errorText;
        private int providerId;
        private int rtbProviderId;
        private int waterfallIndex;
        private boolean isClicked;
        private boolean isOK;
        private String format;
        private String zone;
        private String sessionId;
        private long sessionTime;

        @NonNull
        public Builder errorCode(int errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @NonNull
        public Builder errorText(String errorText) {
            this.errorText = errorText;
            return this;
        }

        @NonNull
        public Builder providerId(int providerId) {
            this.providerId = providerId;
            return this;
        }

        @NonNull
        public Builder rtbProviderId(int rtbProviderId) {
            this.rtbProviderId = rtbProviderId;
            return this;
        }

        @NonNull
        public Builder waterfallIndex(int waterfallIndex) {
            this.waterfallIndex = waterfallIndex;
            return this;
        }

        @NonNull
        public Builder isClicked(boolean isClicked) {
            this.isClicked = isClicked;
            return this;
        }

        @NonNull
        public Builder isOK(boolean isOK) {
            this.isOK = isOK;
            return this;
        }

        @NonNull
        public Builder format(String format) {
            this.format = format;
            return this;
        }

        @NonNull
        public Builder zone(String zone) {
            this.zone = zone;
            return this;
        }

        @NonNull
        public Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @NonNull
        public Builder sessionTime(long sessionTime) {
            this.sessionTime = sessionTime;
            return this;
        }

        @NonNull
        public SdkLog build() {
            SdkLog sdkLog = new SdkLog();
            sdkLog.errorCode = this.errorCode;
            sdkLog.errorText = this.errorText;
            sdkLog.providerId = this.providerId;
            sdkLog.rtbProviderId = this.rtbProviderId;
            sdkLog.waterfallIndex = this.waterfallIndex;
            sdkLog.isClicked = this.isClicked;
            sdkLog.isOK = this.isOK;
            sdkLog.timestamp = new Date().getTime() / 1000L;
            sdkLog.sk = Cryptography.signSha1(sdkLog.timestamp);
            sdkLog.format = this.format;
            sdkLog.zone = this.zone;
            sdkLog.sessionId = this.sessionId;
            sdkLog.sessionTime = this.sessionTime;
            return sdkLog;
        }
    }
}

