/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.mediation;

import androidx.annotation.NonNull;
import co.adcel.ads.mediation.LogService;
import co.adcel.ads.mediation.SdkLog;
import java.util.Date;

public class SessionLoggerService {
    private long resumeTime = -1L;
    private long pauseTime = -1L;
    @NonNull
    private final LogService logService;

    public SessionLoggerService(@NonNull LogService logService) {
        this.logService = logService;
    }

    public void resumeSession() {
        this.checkNeedLogSessionTime();
        this.pauseTime = -1L;
    }

    public void pauseSession() {
        this.pauseTime = new Date().getTime();
    }

    private long getSessionTimeSec() {
        if (this.resumeTime == -1L) {
            return 0L;
        }
        if (this.pauseTime == -1L) {
            long currTime = new Date().getTime();
            return (int)((currTime - this.resumeTime) / 1000L);
        }
        return (this.pauseTime - this.resumeTime) / 1000L;
    }

    private void checkNeedLogSessionTime() {
        long timeAfterPause;
        long currTime = new Date().getTime();
        boolean sessionStarted = this.resumeTime != -1L;
        boolean sessionWasPaused = this.pauseTime != -1L;
        long l = timeAfterPause = sessionWasPaused ? currTime - this.pauseTime : 0L;
        if (sessionStarted && sessionWasPaused && timeAfterPause <= 30000L) {
            this.resumeTime += timeAfterPause;
        } else if (sessionStarted && sessionWasPaused && timeAfterPause > 30000L) {
            this.sendLog(new SdkLog.Builder().format("banner").waterfallIndex(-91).errorCode(73628).sessionTime(this.getSessionTimeSec()).build());
            this.resumeTime = new Date().getTime();
        } else if (!sessionStarted) {
            this.resumeTime = new Date().getTime();
        }
    }

    private void sendLog(SdkLog sdkLog) {
        this.logService.send(sdkLog);
    }
}

