/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.rtb;

import co.adcel.toolkit.JSONObjectExt;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Ad {
    private List<String> clicks = new ArrayList<String>();
    private String html;
    private String vast;
    private String format;
    private String provider;
    private int providerId;
    private int skip;
    private String adomain;
    private boolean zeroOffsets = false;

    Ad(JSONObject json) {
        this.html = JSONObjectExt.optString(json, "html");
        this.vast = JSONObjectExt.optString(json, "vast");
        this.format = JSONObjectExt.optString(json, "format");
        this.provider = JSONObjectExt.optString(json, "provider");
        this.providerId = json.optInt("provider_id", -1);
        this.skip = json.optInt("skip", -1);
        this.adomain = JSONObjectExt.optString(json, "adomain");
        try {
            this.zeroOffsets = Integer.parseInt(JSONObjectExt.optString(json, "zeroOffsets", "0")) > 0;
        }
        catch (NumberFormatException e) {
            this.zeroOffsets = false;
        }
        JSONArray jsonArray = json.optJSONArray("clicks");
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                this.clicks.add(jsonArray.optString(i));
            }
        }
    }

    List<String> getClicks() {
        return this.clicks;
    }

    String getHTML() {
        return this.html;
    }

    String getVAST() {
        return this.vast;
    }

    String getFormat() {
        return this.format;
    }

    String getProvider() {
        return this.provider;
    }

    int getProviderId() {
        return this.providerId;
    }

    int getSkip() {
        return this.skip;
    }

    public String getAdomain() {
        return this.adomain;
    }

    public boolean getZeroOffsets() {
        return this.zeroOffsets;
    }

    String getClickUrl() {
        if (this.clicks.size() > 0) {
            return this.clicks.get(0);
        }
        return null;
    }
}

