/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.rtb;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import co.adcel.ads.base.DeviceUtils;
import co.adcel.ads.rtb.IAdView;
import co.adcel.ads.rtb.InterstitialAd;
import co.adcel.inhouse.drawable.BackgroundButtonClose;

public class AdActivity
extends Activity
implements InterstitialAd.OnAdCanBeClosed,
InterstitialAd.OnAdCompleted {
    private static final String BUTTON_TEXT_MOBILE = "\u2573";
    private static final String BUTTON_TEXT_TV = "SKIP";
    private static InterstitialAd sInterstitialAd;
    private InterstitialAd mInterstitialAd;
    private FrameLayout mViewContainer;
    private Button mBtnClose;
    private View mView;

    static void startActivity(Context context, InterstitialAd interstitialAd) {
        sInterstitialAd = interstitialAd;
        Intent intent = new Intent(context, AdActivity.class);
        intent.setFlags(65536);
        context.startActivity(intent);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mInterstitialAd = sInterstitialAd;
        sInterstitialAd = null;
        this.setRequestedOrientation(this.mInterstitialAd.getScreenOrientation());
        this.mInterstitialAd.setOnAdCanBeClosed(this);
        this.mView = this.mInterstitialAd.createView(this);
        this.mViewContainer = new FrameLayout((Context)this);
        this.mViewContainer.addView(this.mView);
        float density = this.getResources().getDisplayMetrics().density;
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams((int)(20.0f * density), (int)(20.0f * density));
        layoutParams.gravity = 5;
        layoutParams.setMargins(0, (int)(5.0f * density), (int)(5.0f * density), 0);
        this.mBtnClose = new Button((Context)this);
        this.mBtnClose.setTag((Object)"BUTTON_NAME_CLOSE");
        if (DeviceUtils.isGoogleTv((Context)this)) {
            layoutParams.width = -2;
            layoutParams.height = -2;
            this.mBtnClose.setText((CharSequence)BUTTON_TEXT_TV);
            this.mBtnClose.setTextSize(density * 7.0f);
            this.mBtnClose.setTextColor(-7829368);
            this.mBtnClose.setBackgroundColor(-1);
            this.mBtnClose.setMinHeight(0);
            this.mBtnClose.setPadding((int)(5.0f * density), 0, (int)(5.0f * density), 0);
        } else {
            this.mBtnClose.setText((CharSequence)BUTTON_TEXT_MOBILE);
            this.mBtnClose.setBackground((Drawable)new BackgroundButtonClose());
            this.mBtnClose.setTextColor(-16777216);
            this.mBtnClose.setPadding((int)(1.0f * density), 0, (int)(1.0f * density), (int)(1.0f * density));
        }
        this.mBtnClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AdActivity.this.onBackPressed();
            }
        });
        if (!this.mInterstitialAd.canBeClosed()) {
            this.mBtnClose.setVisibility(8);
        }
        this.mViewContainer.addView((View)this.mBtnClose, (ViewGroup.LayoutParams)layoutParams);
        this.setContentView((View)this.mViewContainer);
    }

    public void onBackPressed() {
        if (this.mInterstitialAd.canBeClosed()) {
            if (!this.mInterstitialAd.isShown()) {
                this.mInterstitialAd.showFailed();
            }
            this.mInterstitialAd.close();
            super.onBackPressed();
        }
    }

    @Override
    public void onAdCanBeClosed() {
        this.mBtnClose.post(new Runnable(){

            @Override
            public void run() {
                AdActivity.this.mBtnClose.setVisibility(0);
                AdActivity.this.mBtnClose.requestFocus();
            }
        });
    }

    @Override
    public void onAdCompleted() {
        if (DeviceUtils.isGoogleTv((Context)this)) {
            this.onBackPressed();
        }
    }

    protected void onPause() {
        if (this.mView != null && this.mView instanceof IAdView) {
            ((IAdView)this.mView).onPause();
        }
        super.onPause();
    }

    protected void onResume() {
        super.onResume();
        if (this.mView != null && this.mView instanceof IAdView) {
            ((IAdView)this.mView).onResume();
        }
    }
}

