/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.rtb;

import android.app.Activity;
import android.content.Context;
import android.media.MediaPlayer;
import co.adcel.ads.mediation.MediationContext;
import co.adcel.ads.rtb.AudioAdEventListener;
import co.adcel.ads.rtb.InstreamaticLoader;
import co.adcel.ads.rtb.RTBAd;
import co.adcel.ads.rtb.RtbAdRequest;
import co.adcel.ads.rtb.VASTAd;
import co.adcel.ads.rtb.VASTHelper;
import co.adcel.ads.rtb.VASTParser;
import co.adcel.logger.AdsATALog;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;

public class AudioAd
extends RTBAd
implements InstreamaticLoader.InstreamaticLoaderListener {
    private MediationContext mediationContext;
    private AudioAdEventListener audioAdEventListener;
    private VASTAd mVastAd;
    private MediaPlayer mediaPlayer;
    private Timer mAudioTimer;
    int prevPlaybackTime = 0;
    boolean skippable = true;
    private InstreamaticLoader instreamaticLoader;
    private VASTHelper vastHelper;

    public AudioAd(MediationContext mediationContext, String options) {
        super(mediationContext.getContext(), mediationContext.getSdkKey(), options);
        this.mediationContext = mediationContext;
        this.instreamaticLoader = new InstreamaticLoader(mediationContext, this);
    }

    public void setAudioAdEventListener(AudioAdEventListener audioAdEventListener) {
        this.audioAdEventListener = audioAdEventListener;
    }

    VASTAd getVastAd() {
        return this.mVastAd;
    }

    @Override
    RtbAdRequest.Builder createUriBuilder(Context context) {
        return new RtbAdRequest.Builder("audio");
    }

    @Override
    void loadSuccess(int providerId) {
        VASTParser vastParser = new VASTParser();
        if (this.getAd().getVAST() != null) {
            this.mVastAd = vastParser.parse(this.getAd().getVAST());
            if (this.mVastAd == null) {
                this.loadFailed("Audio ad parsing error. VAST is invalid");
            } else if (this.audioAdEventListener != null) {
                this.audioAdEventListener.onAudioAdLoad();
            }
        } else {
            this.loadFailed("Video ad format error. VAST is null");
        }
    }

    @Override
    void loadFailed(String error) {
        if (this.audioAdEventListener != null) {
            this.audioAdEventListener.onAudioAdFailed(error);
        }
    }

    @Override
    public void onLoadSuccess() {
        if (this.audioAdEventListener != null) {
            this.audioAdEventListener.onAudioAdLoad();
        }
    }

    @Override
    public void onLoadFailed() {
        super.load();
    }

    @Override
    public void onAudioAdStart() {
        if (this.audioAdEventListener != null) {
            this.audioAdEventListener.onAudioAdStart();
        }
    }

    @Override
    public void onAudioAdComplete() {
        if (this.audioAdEventListener != null) {
            this.audioAdEventListener.onAudioAdComplete();
        }
    }

    @Override
    public void load() {
        if (!this.instreamaticLoader.load()) {
            super.load();
        }
    }

    @Override
    void click() {
    }

    private VASTHelper getVastHelper() {
        if (this.vastHelper == null) {
            this.vastHelper = new VASTHelper();
        }
        return this.vastHelper;
    }

    @Override
    void trackImpression() {
        this.getVastHelper().trackImpression(this.getVastAd());
    }

    private void startTimer() {
        this.mAudioTimer = new Timer();
        this.mAudioTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ((Activity)AudioAd.this.getContext()).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (AudioAd.this.mAudioTimer != null) {
                            int duration;
                            int currentTime = AudioAd.this.mediaPlayer.getCurrentPosition();
                            if (currentTime >= (duration = AudioAd.this.mediaPlayer.getDuration()) / 4 && currentTime > AudioAd.this.prevPlaybackTime && AudioAd.this.prevPlaybackTime < duration / 4) {
                                AudioAd.this.getVastHelper().trackEvent(AudioAd.this.getVastAd(), "firstQuartile");
                            } else if (currentTime >= duration / 2 && currentTime > AudioAd.this.prevPlaybackTime && AudioAd.this.prevPlaybackTime < duration / 2) {
                                AudioAd.this.getVastHelper().trackEvent(AudioAd.this.getVastAd(), "midpoint");
                            } else if (currentTime >= duration / 4 * 3 && currentTime > AudioAd.this.prevPlaybackTime && AudioAd.this.prevPlaybackTime < duration / 4 * 3) {
                                AudioAd.this.getVastHelper().trackEvent(AudioAd.this.getVastAd(), "thirdQuartile");
                            }
                            AudioAd.this.prevPlaybackTime = currentTime;
                            if (AudioAd.this.audioAdEventListener != null) {
                                AudioAd.this.audioAdEventListener.onAudioAdPlaybackInfo(duration, currentTime);
                            }
                            boolean skippable = AudioAd.this.isSkippable();
                            if (AudioAd.this.audioAdEventListener != null && skippable != AudioAd.this.skippable) {
                                AudioAd.this.audioAdEventListener.onAudioAdSkipAllow(skippable);
                            }
                            AudioAd.this.skippable = skippable;
                        }
                    }
                });
            }
        }, 500L, 500L);
    }

    public void play() {
        if (this.instreamaticLoader.play()) {
            return;
        }
        if (this.getVastAd() == null) {
            return;
        }
        if (this.mediaPlayer != null) {
            this.resume();
            return;
        }
        VASTAd.MediaFile mediaFile = null;
        for (VASTAd.MediaFile mf : this.getVastAd().creative.mediaFiles) {
            if (!mf.type.equals("audio/mp3")) continue;
            mediaFile = mf;
        }
        if (mediaFile != null) {
            this.mediaPlayer = new MediaPlayer();
            this.mediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(MediaPlayer mediaPlayer) {
                    AudioAd.this.getVastHelper().trackEvent(AudioAd.this.getVastAd(), "start");
                    AudioAd.this.startTimer();
                    if (AudioAd.this.audioAdEventListener != null) {
                        AudioAd.this.audioAdEventListener.onAudioAdStart();
                    }
                }
            });
            this.mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                public void onCompletion(MediaPlayer mediaPlayer) {
                    AudioAd.this.getVastHelper().trackEvent(AudioAd.this.getVastAd(), "complete");
                    if (AudioAd.this.mAudioTimer != null) {
                        AudioAd.this.mAudioTimer.cancel();
                        AudioAd.this.mAudioTimer = null;
                    }
                    AudioAd.this.prevPlaybackTime = 0;
                    if (AudioAd.this.audioAdEventListener != null) {
                        AudioAd.this.audioAdEventListener.onAudioAdComplete();
                    }
                }
            });
            try {
                this.mediaPlayer.setDataSource(mediaFile.url);
                this.mediaPlayer.prepare();
            }
            catch (IOException e) {
                AdsATALog.e("AudioAd play error: " + e.getMessage());
            }
            this.mediaPlayer.start();
        }
    }

    public boolean isPlaying() {
        return this.instreamaticLoader.isPlaying() || this.mediaPlayer != null && this.mediaPlayer.isPlaying();
    }

    public void pause() {
        if (this.instreamaticLoader.pause()) {
            return;
        }
        if (this.mediaPlayer == null || !this.mediaPlayer.isPlaying()) {
            return;
        }
        this.mediaPlayer.pause();
        this.getVastHelper().trackEvent(this.getVastAd(), "pause");
    }

    public void resume() {
        if (this.instreamaticLoader.play()) {
            return;
        }
        if (this.mediaPlayer == null || this.mediaPlayer.isPlaying()) {
            return;
        }
        this.mediaPlayer.start();
        this.getVastHelper().trackEvent(this.getVastAd(), "resume");
    }

    public void rewind() {
        if (this.mediaPlayer == null) {
            return;
        }
        this.mediaPlayer.seekTo(0);
        this.getVastHelper().trackEvent(this.getVastAd(), "rewind");
    }

    public boolean isSkippable() {
        if (this.getVastAd() == null || this.mediaPlayer == null) {
            return false;
        }
        String skipTime = this.getVastAd().extensions.get("skipTime");
        if (skipTime == null) {
            skipTime = this.getVastAd().extensions.get("skipTime2");
        }
        if (skipTime != null) {
            String[] comp = skipTime.split(":");
            int skipSec = Integer.parseInt(comp[0]);
            int currentTime = this.mediaPlayer.getCurrentPosition() / 1000;
            return currentTime >= skipSec;
        }
        return true;
    }

    public void skip() {
        if (this.instreamaticLoader.skip()) {
            return;
        }
        if (this.mediaPlayer == null || !this.isSkippable()) {
            return;
        }
        this.mediaPlayer.stop();
        this.getVastHelper().trackEvent(this.getVastAd(), "skip");
    }
}

