/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.rtb;

import android.content.Context;
import android.location.Location;
import android.net.Uri;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import co.adcel.ads.rtb.BannerAd;
import co.adcel.ads.rtb.BannerAdEventListener;
import co.adcel.ads.rtb.HtmlAdView;

public class BannerAdView
extends WebView
implements BannerAdEventListener,
View.OnTouchListener {
    private BannerAd mBannerAd;
    private BannerAdEventListener mBannerAdEventListener;
    private BannerSize mBannerSize = new BannerSize(320, 50);
    private Location mLocation;
    private boolean gdprConsent = true;
    private WebViewClient mWebViewClient = new WebViewClient(){

        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            if (Build.VERSION.SDK_INT >= 21) {
                Uri uri = request.getUrl();
                String clickUrl = BannerAdView.this.mBannerAd.getAd().getClickUrl();
                if (clickUrl != null && uri.toString().equals(clickUrl)) {
                    return true;
                }
                if (uri.toString().contains("click")) {
                    BannerAdView.this.mBannerAd.openClickUrl(uri.toString());
                    BannerAdView.this.onAdClicked();
                    return true;
                }
            }
            return super.shouldOverrideUrlLoading(view, request);
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            String clickUrl = BannerAdView.this.mBannerAd.getAd().getClickUrl();
            if (clickUrl != null && url.equals(clickUrl)) {
                return true;
            }
            if (url.contains("click")) {
                BannerAdView.this.mBannerAd.openClickUrl(url);
                BannerAdView.this.onAdClicked();
                return true;
            }
            return super.shouldOverrideUrlLoading(view, url);
        }

        public void onPageFinished(WebView view, String url) {
            if (BannerAdView.this.mBannerAd.getAd().getZeroOffsets()) {
                BannerAdView.this.loadUrl("javascript:document.body.style.padding=0;document.body.style.margin=0;");
            }
        }
    };

    public BannerAdView(Context context) {
        super(context);
        this.init();
    }

    public BannerAdView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public BannerAdView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    void init() {
        this.getSettings().setJavaScriptEnabled(true);
        this.setWebViewClient(this.mWebViewClient);
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        String clickUrl;
        if (motionEvent.getAction() == 0 && (clickUrl = this.mBannerAd.getAd().getClickUrl()) != null) {
            this.mBannerAd.openClickUrl(clickUrl);
            this.onAdClicked();
            return true;
        }
        return false;
    }

    public void setBannerAdEventListener(BannerAdEventListener bannerAdEventListener) {
        this.mBannerAdEventListener = bannerAdEventListener;
    }

    public void setLocation(Location location) {
        this.mLocation = location;
        if (this.mBannerAd != null) {
            this.mBannerAd.setLocation(this.mLocation);
        }
    }

    public void setGdprConsent(boolean gdprConsent) {
        this.gdprConsent = gdprConsent;
        if (this.mBannerAd != null) {
            this.mBannerAd.setGdprConsent(gdprConsent);
        }
    }

    public void setKey(String key, String options) {
        this.mBannerAd = new BannerAd(this.getContext(), key, options);
        this.mBannerAd.setBannerAdEventListener(this);
        if (this.mBannerSize != null) {
            this.mBannerAd.setSize(this.mBannerSize);
        }
        if (this.mLocation != null) {
            this.mBannerAd.setLocation(this.mLocation);
        }
        this.mBannerAd.setGdprConsent(this.gdprConsent);
    }

    public void setSize(BannerSize bannerSize) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        float density = this.getContext().getResources().getDisplayMetrics().density;
        int width = displayMetrics.widthPixels;
        this.mBannerSize = bannerSize;
        if (this.mBannerSize.width <= 0) {
            this.mBannerSize.width = (int)((float)width / density);
        }
        if (this.mBannerSize.height <= 0) {
            this.mBannerSize.height = 50;
        }
        if (this.mBannerAd != null) {
            this.mBannerAd.setSize(this.mBannerSize);
        }
    }

    public void load() {
        if (this.mBannerAd == null) {
            throw new IllegalStateException("Key is not set");
        }
        this.mBannerAd.load();
    }

    @Override
    public void onAdLoad(int providerId) {
        if (this.mBannerAd.getAd() == null || this.mBannerAd.getAd().getHTML() == null) {
            this.onAdFailedToLoad("Invalid Ad response");
            return;
        }
        String clickUrl = this.mBannerAd.getAd().getClickUrl();
        if (clickUrl != null) {
            this.setOnTouchListener(this);
        }
        String html = HtmlAdView.getNormalizedHtml(this.mBannerAd.getAd().getHTML());
        String baseUrl = this.mBannerAd.getAd().getAdomain();
        if (baseUrl != null) {
            this.loadDataWithBaseURL(baseUrl, html, "text/html", "UTF-8", null);
        } else {
            this.loadData(html, "text/html", "UTF-8");
        }
        if (this.mBannerAdEventListener != null) {
            this.mBannerAdEventListener.onAdLoad(providerId);
        }
    }

    @Override
    public void onAdFailedToLoad(String error) {
        if (this.mBannerAdEventListener != null) {
            this.mBannerAdEventListener.onAdFailedToLoad(error);
        }
    }

    @Override
    public void onAdClicked() {
        if (this.mBannerAdEventListener != null) {
            this.mBannerAdEventListener.onAdClicked();
        }
    }

    public static class BannerSize {
        public int width;
        public int height;

        public BannerSize(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }
}

