/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.rtb;

import android.net.Uri;
import androidx.annotation.NonNull;
import co.adcel.ads.base.BaseWebService;
import co.adcel.ads.base.SdkConfig;
import co.adcel.ads.base.SdkConfigProvider;
import co.adcel.ads.base.WebServiceCallback;
import co.adcel.ads.rtb.AdWebService;
import co.adcel.ads.rtb.RtbAdRequest;
import co.adcel.http.HttpClient;
import co.adcel.http.Request;
import co.adcel.toolkit.JsonStringDeserialization;
import co.adcel.toolkit.RawJsonStringDeserialization;

public final class DefaultAdWebService
extends BaseWebService
implements AdWebService {
    private static final String PATH_AD = "ad";
    protected static final String PARAM_ANDROIDID = "androidid";
    protected static final String PARAM_OSV = "osv";
    protected static final String PARAM_MODEL = "model";
    protected static final String PARAM_DEVW = "devw";
    protected static final String PARAM_DEVH = "devh";
    protected static final String PARAM_PPI = "ppi";
    protected static final String PARAM_PXRATIO = "pxratio";
    protected static final String PARAM_JS = "js";
    protected static final String PARAM_LANGUAGE = "language";
    protected static final String PARAM_LINEARITY = "linearity";
    protected static final String PARAM_CARRIER = "carrier";
    protected static final String PARAM_CONNECTIONTYPE = "connectiontype";
    protected static final String PARAM_LAT = "lat";
    protected static final String PARAM_LON = "lon";
    protected static final String PARAM_W = "w";
    protected static final String PARAM_H = "h";
    protected static final String PARAM_JS_DEFAULT_VALUE = "1";

    public DefaultAdWebService(@NonNull HttpClient httpClient, @NonNull SdkConfigProvider sdkConfigProvider) {
        super(httpClient, sdkConfigProvider);
    }

    @Override
    public void getRtbAd(final @NonNull RtbAdRequest request, final @NonNull WebServiceCallback<String> callback) {
        this.getSdkConfigProvider(new SdkConfigProvider.Listener(){

            @Override
            public void onSdkConfigRetrieved(@NonNull SdkConfig sdkConfig) {
                DefaultAdWebService.this.executeRtbAdRequest(request, sdkConfig, callback, new RawJsonStringDeserialization());
            }
        });
    }

    private <T> void executeRtbAdRequest(@NonNull RtbAdRequest request, @NonNull SdkConfig sdkConfig, @NonNull WebServiceCallback<T> callback, @NonNull JsonStringDeserialization<T> deserialization) {
        Uri.Builder uriBuilder = this.createBaseUriBuilder().appendPath(PATH_AD).appendQueryParameter(PARAM_JS, PARAM_JS_DEFAULT_VALUE).appendQueryParameter("platform", sdkConfig.getPlatform()).appendQueryParameter("bundle", sdkConfig.getBundle()).appendQueryParameter("format", request.getFormat()).appendQueryParameter(PARAM_LINEARITY, String.valueOf(request.getLinearity())).appendQueryParameter(PARAM_DEVW, String.valueOf(request.getDeviceWidth())).appendQueryParameter(PARAM_DEVH, String.valueOf(request.getDeviceHeight())).appendQueryParameter(PARAM_PPI, String.valueOf(request.getPpi())).appendQueryParameter(PARAM_PXRATIO, String.valueOf(request.getPixelRatio())).appendQueryParameter("gdpr_consent", request.isGdprConsent() ? PARAM_JS_DEFAULT_VALUE : "0").appendQueryParameter(PARAM_W, String.valueOf(request.getAdWidth())).appendQueryParameter(PARAM_H, String.valueOf(request.getAdHeight()));
        if (request.getAndroidId() != null) {
            uriBuilder.appendQueryParameter(PARAM_ANDROIDID, request.getAndroidId());
        }
        if (request.getOsVersion() != null) {
            uriBuilder.appendQueryParameter(PARAM_OSV, request.getOsVersion());
        }
        if (request.getModel() != null) {
            uriBuilder.appendQueryParameter(PARAM_MODEL, request.getModel());
        }
        if (request.getLanguage() != null) {
            uriBuilder.appendQueryParameter(PARAM_LANGUAGE, request.getLanguage());
        }
        if (request.getCarrier() != null) {
            uriBuilder.appendQueryParameter(PARAM_CARRIER, request.getCarrier());
        }
        if (request.getConnectionType() != null) {
            uriBuilder.appendQueryParameter(PARAM_CONNECTIONTYPE, request.getConnectionType());
        }
        if (request.getLat() != null) {
            uriBuilder.appendQueryParameter(PARAM_LAT, String.valueOf(request.getLat()));
        }
        if (request.getLon() != null) {
            uriBuilder.appendQueryParameter(PARAM_LON, String.valueOf(request.getLon()));
        }
        if (sdkConfig.getAdId() != null) {
            uriBuilder.appendQueryParameter("adid", sdkConfig.getAdId());
        }
        String url = uriBuilder.build().toString();
        if (request.getExtraUrlQuery() != null) {
            url = url + "&" + request.getExtraUrlQuery();
        }
        Request httpRequest = new Request.Builder(url).header("Authorization", this.getAuthorizationToken(sdkConfig.getKey())).build();
        this.executeRequest(httpRequest, callback, deserialization);
    }
}

