/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.rtb;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.NonNull;
import co.adcel.ads.rtb.InterstitialAd;

public class HtmlAdView
extends WebView
implements View.OnTouchListener {
    private InterstitialAd mInterstitialAd;
    private WebViewClient mWebViewClient = new WebViewClient(){

        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            if (Build.VERSION.SDK_INT >= 21) {
                Uri uri = request.getUrl();
                String clickUrl = HtmlAdView.this.mInterstitialAd.getAd().getClickUrl();
                if (clickUrl != null && uri.toString().equals(clickUrl)) {
                    return true;
                }
                if (uri.toString().contains("click")) {
                    HtmlAdView.this.mInterstitialAd.openClickUrl(uri.toString());
                    HtmlAdView.this.mInterstitialAd.click();
                    return true;
                }
            }
            return super.shouldOverrideUrlLoading(view, request);
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            String clickUrl = HtmlAdView.this.mInterstitialAd.getAd().getClickUrl();
            if (clickUrl != null && url.equals(clickUrl)) {
                return true;
            }
            if (url.contains("click")) {
                HtmlAdView.this.mInterstitialAd.openClickUrl(url);
                HtmlAdView.this.mInterstitialAd.click();
                return true;
            }
            return super.shouldOverrideUrlLoading(view, url);
        }

        public void onPageFinished(WebView view, String url) {
            if (HtmlAdView.this.mInterstitialAd.getAd().getZeroOffsets()) {
                HtmlAdView.this.loadUrl("javascript:document.body.style.padding=0;document.body.style.margin=0;");
            }
        }
    };

    public HtmlAdView(@NonNull Context context, InterstitialAd interstitialAd) {
        super(context);
        this.mInterstitialAd = interstitialAd;
        this.getSettings().setJavaScriptEnabled(true);
        String clickUrl = this.mInterstitialAd.getAd().getClickUrl();
        if (clickUrl != null) {
            this.setOnTouchListener(this);
        }
        this.setWebViewClient(this.mWebViewClient);
        String html = HtmlAdView.getNormalizedHtml(this.mInterstitialAd.getAd().getHTML());
        String baseUrl = this.mInterstitialAd.getAd().getAdomain();
        if (baseUrl != null) {
            this.loadDataWithBaseURL(baseUrl, html, "text/html", "UTF-8", null);
        } else {
            this.loadData(html, "text/html", "UTF-8");
        }
        this.mInterstitialAd.adShow();
    }

    static String getNormalizedHtml(String html) {
        boolean validHtml;
        String normalizedHtml = html;
        boolean bl = validHtml = normalizedHtml.trim().startsWith("<!DOCTYPE") || normalizedHtml.trim().startsWith("<html");
        if (!validHtml) {
            normalizedHtml = String.format("<html><head></head><body>%s</body></html>", normalizedHtml);
        }
        return normalizedHtml;
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        String clickUrl;
        if (motionEvent.getAction() == 0 && (clickUrl = this.mInterstitialAd.getAd().getClickUrl()) != null) {
            this.mInterstitialAd.openClickUrl(clickUrl);
            this.mInterstitialAd.click();
            return true;
        }
        return false;
    }
}

