/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.rtb;

import android.content.Context;
import android.content.pm.PackageManager;
import android.util.Log;
import co.adcel.ads.mediation.MediationContext;
import co.adcel.common.AdProviderDTO;
import co.adcel.logger.AdsATALog;
import com.instreamatic.adman.Adman;
import com.instreamatic.adman.AdmanRequest;
import com.instreamatic.adman.IAdman;
import com.instreamatic.adman.Region;
import com.instreamatic.adman.Type;
import com.instreamatic.adman.event.AdmanEvent;
import com.instreamatic.adman.event.EventListener;
import com.instreamatic.adman.module.IAdmanModule;
import com.instreamatic.adman.voice.AdmanVoice;
import com.instreamatic.adman.voice.VoiceEvent;

public class InstreamaticLoader
implements AdmanEvent.Listener,
VoiceEvent.Listener {
    private static final String TAG = "DemoAdmanVoice";
    private MediationContext mediationContext;
    private IAdman adman;
    private InstreamaticLoaderListener listener;

    InstreamaticLoader(MediationContext mediationContext, InstreamaticLoaderListener listener) {
        this.mediationContext = mediationContext;
        this.listener = listener;
    }

    private Context getContext() {
        return this.mediationContext.getContext();
    }

    boolean load() {
        try {
            Class.forName("com.instreamatic.adman.Adman");
            Class.forName("com.instreamatic.adman.voice.AdmanVoice");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        AdProviderDTO provider = this.mediationContext.getProvider("Instreamatic", "audio");
        if (provider == null) {
            return false;
        }
        Context context = this.getContext();
        if (context == null) {
            return false;
        }
        String packageName = context.getApplicationContext().getPackageName();
        PackageManager pm = null;
        try {
            pm = context.getPackageManager();
        }
        catch (Throwable e) {
            AdsATALog.e("InstreamaticLoader load error: " + e.getMessage());
        }
        if (pm == null) {
            return false;
        }
        int hasPerm = pm.checkPermission("android.permission.RECORD_AUDIO", packageName);
        if (hasPerm != 0) {
            return false;
        }
        AdmanRequest request = new AdmanRequest.Builder().setSiteId(Integer.valueOf(Integer.parseInt(provider.getAppId()))).setRegion(Region.values()[Integer.parseInt(provider.getAppKey())]).setType(Type.VOICE).build();
        this.adman = new Adman(context, request);
        this.adman.bindModule((IAdmanModule)new AdmanVoice(context));
        this.adman.getDispatcher().addListener(AdmanEvent.TYPE, (EventListener)this);
        this.adman.getDispatcher().addListener(VoiceEvent.TYPE, (EventListener)this);
        this.adman.start();
        return true;
    }

    boolean pause() {
        if (this.adman == null) {
            return false;
        }
        this.adman.pause();
        return true;
    }

    boolean play() {
        if (this.adman == null) {
            return false;
        }
        this.adman.play();
        return true;
    }

    boolean isPlaying() {
        if (this.adman == null) {
            return false;
        }
        return this.adman.isPlaying();
    }

    boolean skip() {
        if (this.adman == null) {
            return false;
        }
        this.adman.skip();
        return true;
    }

    void destroy() {
        if (this.adman == null) {
            return;
        }
        this.adman.getDispatcher().removeListener(AdmanEvent.TYPE, (EventListener)this);
        this.adman.getDispatcher().removeListener(VoiceEvent.TYPE, (EventListener)this);
        this.adman = null;
    }

    public void onAdmanEvent(AdmanEvent admanEvent) {
        switch ((AdmanEvent.Type)admanEvent.getType()) {
            case READY: {
                if (this.listener == null) break;
                this.listener.onLoadSuccess();
                break;
            }
            case STARTED: {
                if (this.listener == null) break;
                this.listener.onAudioAdStart();
                break;
            }
            case SKIPPED: 
            case COMPLETED: {
                this.destroy();
                if (this.listener == null) break;
                this.listener.onAudioAdComplete();
                break;
            }
            case NONE: 
            case FAILED: {
                this.destroy();
                if (this.listener == null) break;
                this.listener.onLoadFailed();
            }
        }
    }

    public void onVoiceEvent(VoiceEvent voiceEvent) {
        switch ((VoiceEvent.Type)voiceEvent.getType()) {
            case UPDATE: {
                Log.d((String)TAG, (String)("onVoiceEvent: " + ((VoiceEvent.Type)voiceEvent.getType()).name() + " -- " + voiceEvent.getTranscript()));
                break;
            }
            case RESPONSE: {
                Log.d((String)TAG, (String)("onVoiceEvent: " + ((VoiceEvent.Type)voiceEvent.getType()).name() + " -- " + voiceEvent.getResponse().action));
                break;
            }
            default: {
                Log.d((String)TAG, (String)("onVoiceEvent: " + ((VoiceEvent.Type)voiceEvent.getType()).name()));
            }
        }
    }

    static interface InstreamaticLoaderListener {
        public void onLoadSuccess();

        public void onLoadFailed();

        public void onAudioAdStart();

        public void onAudioAdComplete();
    }
}

