/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.rtb;

import android.content.Context;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.WindowManager;
import co.adcel.ads.base.DeviceUtils;
import co.adcel.ads.rtb.AdActivity;
import co.adcel.ads.rtb.HtmlAdView;
import co.adcel.ads.rtb.InterstitialAdEventListener;
import co.adcel.ads.rtb.RTBAd;
import co.adcel.ads.rtb.RtbAdRequest;

public class InterstitialAd
extends RTBAd {
    private static final int INTERSTITIAL_MOBILE_DEFAULT_WIDTH = 320;
    private static final int INTERSTITIAL_MOBILE_DEFAULT_HEIGHT = 480;
    private static final int INTERSTITIAL_TV_DEFAULT_WIDTH = 1920;
    private static final int INTERSTITIAL_TV_DEFAULT_HEIGHT = 1080;
    protected InterstitialAdEventListener mInterstitialAdEventListener;
    protected OnAdCanBeClosed mOnAdCanBeClosed;
    private int mScreenOrientation = 1;
    private boolean isShown = false;
    private String adType = "image";

    public InterstitialAd(Context context, String key, String options) {
        super(context, key, options);
    }

    public InterstitialAd(Context context, String key, String options, String adType) {
        super(context, key, options);
        this.adType = adType;
    }

    public void setInterstitialAdEventListener(InterstitialAdEventListener interstitialAdEventListener) {
        this.mInterstitialAdEventListener = interstitialAdEventListener;
    }

    void setOnAdCanBeClosed(OnAdCanBeClosed onAdCanBeClosed) {
        this.mOnAdCanBeClosed = onAdCanBeClosed;
    }

    @Override
    RtbAdRequest.Builder createUriBuilder(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        int height = displayMetrics.heightPixels;
        int width = displayMetrics.widthPixels;
        this.mScreenOrientation = height > width ? 1 : 0;
        RtbAdRequest.Builder builder = new RtbAdRequest.Builder(this.adType);
        int adWidth = 320;
        int adHeight = 480;
        if (DeviceUtils.isGoogleTv(this.getContext())) {
            adWidth = 1920;
            adHeight = 1080;
        }
        builder.adWidth(adWidth);
        builder.adHeight(adHeight);
        return builder;
    }

    int getScreenOrientation() {
        return this.mScreenOrientation;
    }

    public void show() {
        if (!this.isReadyToShow()) {
            this.showFailed();
            return;
        }
        Context context = this.getContext();
        if (context == null) {
            this.showFailed();
            return;
        }
        AdActivity.startActivity(context, this);
    }

    View createView(OnAdCompleted onAdCompleted) {
        return new HtmlAdView(this.getContext(), this);
    }

    @Override
    void loadSuccess(int providerId) {
        if (this.getAd().getHTML() == null && (this.getAd().getFormat().equals("image") || this.getAd().getFormat().equals("interstitial"))) {
            this.loadFailed("Interstitial ad format error. Content is empty");
            return;
        }
        if (this.mInterstitialAdEventListener != null) {
            this.mInterstitialAdEventListener.onAdLoadSuccess(providerId);
        }
    }

    @Override
    void loadFailed(String error) {
        if (this.mInterstitialAdEventListener != null) {
            this.mInterstitialAdEventListener.onAdLoadFailure(error);
        }
    }

    void adShow() {
        this.isShown = true;
        if (this.mInterstitialAdEventListener != null) {
            this.mInterstitialAdEventListener.onAdShow();
        }
    }

    void showFailed() {
        if (this.mInterstitialAdEventListener != null) {
            this.mInterstitialAdEventListener.onAdShowFailed();
        }
    }

    @Override
    void click() {
        if (this.mInterstitialAdEventListener != null) {
            this.mInterstitialAdEventListener.onAdClick();
        }
    }

    @Override
    void trackImpression() {
    }

    void close() {
        if (this.mInterstitialAdEventListener != null) {
            this.mInterstitialAdEventListener.onAdClose();
        }
    }

    boolean canBeClosed() {
        return true;
    }

    public boolean isShown() {
        return this.isShown;
    }

    static interface OnAdCompleted {
        public void onAdCompleted();
    }

    public static interface OnAdCanBeClosed {
        public void onAdCanBeClosed();
    }
}

