/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.rtb;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import co.adcel.ads.base.SdkPlugin;
import co.adcel.ads.base.WebServiceCallback;
import co.adcel.ads.base.WebServiceError;
import co.adcel.ads.rtb.Ad;
import co.adcel.ads.rtb.AdWebService;
import co.adcel.ads.rtb.DependenciesFactory;
import co.adcel.ads.rtb.RtbAdRequest;
import co.adcel.common.Utilities;
import co.adcel.init.AdCel;
import co.adcel.toolkit.JSONObjectExt;
import java.lang.ref.WeakReference;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class RTBAd {
    private WeakReference<Context> mRefContext;
    private String mOptions;
    private Ad mAd;
    private Location mLocation;
    private boolean gdprConsent = true;
    private AdWebService adWebService;
    private Handler mainHandler;

    RTBAd(Context context, String key, String options) {
        this.mRefContext = new WeakReference<Context>(context);
        this.mOptions = options;
        SdkPlugin sdkPlugin = null;
        String adCelPluginName = AdCel.pluginName();
        if (adCelPluginName != null) {
            sdkPlugin = SdkPlugin.fromName(adCelPluginName);
        }
        DependenciesFactory dependenciesFactory = new DependenciesFactory(context, key, sdkPlugin);
        this.adWebService = dependenciesFactory.getAdWebService();
        if (this.adWebService == null) {
            throw new IllegalStateException("sdk initialized incorrectly");
        }
    }

    public Handler getMainHandler() {
        if (this.mainHandler == null) {
            this.mainHandler = new Handler(Looper.getMainLooper());
        }
        return this.mainHandler;
    }

    public void setGdprConsent(boolean gdprConsent) {
        this.gdprConsent = gdprConsent;
    }

    public void setLocation(Location location) {
        this.mLocation = location;
    }

    @Nullable
    Context getContext() {
        return (Context)this.mRefContext.get();
    }

    Ad getAd() {
        return this.mAd;
    }

    abstract RtbAdRequest.Builder createUriBuilder(Context var1);

    public void load() {
        Context context = (Context)this.mRefContext.get();
        if (context == null) {
            this.loadFailed("context is null");
            return;
        }
        RtbAdRequest.Builder builder = this.createUriBuilder(context);
        String osv = Build.VERSION.RELEASE;
        String model = Build.MODEL;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        int height = displayMetrics.heightPixels;
        int width = displayMetrics.widthPixels;
        float ppi = context.getResources().getDisplayMetrics().densityDpi;
        float pxratio = context.getResources().getDisplayMetrics().density;
        String lng = Locale.getDefault().getISO3Language();
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        builder.androidId(androidId);
        builder.osVersion(osv);
        builder.model(model);
        builder.deviceWidth(width);
        builder.deviceHeight(height);
        builder.ppi(ppi);
        builder.pixelRatio(pxratio);
        builder.language(lng);
        String networkOperatorName = Utilities.getNetworkOperatorName(context);
        builder.carrier(networkOperatorName);
        String conType = Utilities.getRtbConnectionType(context);
        builder.connectionType(conType);
        if (this.mLocation != null) {
            builder.lat(this.mLocation.getLatitude());
            builder.lon(this.mLocation.getLongitude());
        }
        builder.gdprConsent(this.gdprConsent);
        if (this.mOptions != null && this.mOptions.trim().length() > 0) {
            builder.extraUrlQuery(this.mOptions);
        }
        this.adWebService.getRtbAd(builder.build(), new WebServiceCallback<String>(){

            @Override
            public void onSuccess(final @NonNull String response) {
                RTBAd.this.getMainHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        RTBAd.this.completeLoad(response);
                    }
                });
            }

            @Override
            public void onError(final @NonNull WebServiceError error) {
                RTBAd.this.getMainHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        RTBAd.this.loadFailed(error.getMessage());
                    }
                });
            }
        });
    }

    private void completeLoad(String response) {
        try {
            JSONObject json = new JSONObject(response);
            String sStatus = JSONObjectExt.optString(json, "status");
            JSONObject adJson = json.optJSONObject("ad");
            if (sStatus.equals("ok") && adJson != null) {
                this.mAd = new Ad(adJson);
                this.loadSuccess(this.mAd.getProviderId());
            } else {
                this.loadFailed(String.format("There is no data downloaded, status: %s", sStatus));
            }
        }
        catch (JSONException e) {
            this.loadFailed("There is no data downloaded, status: invalid json");
        }
    }

    public boolean isReadyToShow() {
        return this.mAd != null;
    }

    abstract void loadSuccess(int var1);

    abstract void loadFailed(String var1);

    abstract void click();

    abstract void trackImpression();

    void openClickUrl(String url) {
        Intent i = new Intent("android.intent.action.VIEW");
        i.setData(Uri.parse((String)url));
        this.getContext().startActivity(i);
    }
}

