/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.rtb;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class RtbAdRequest {
    public static final String CONNECTION_TYPE_UNKNOWN = "0";
    public static final String CONNECTION_TYPE_ETHERNET = "1";
    public static final String CONNECTION_TYPE_WIFI = "2";
    public static final String CONNECTION_TYPE_CELLULAR_UNKNOWN = "3";
    public static final String CONNECTION_TYPE_2G = "4";
    public static final String CONNECTION_TYPE_3G = "5";
    public static final String CONNECTION_TYPE_4G = "6";
    @NonNull
    private final String format;
    @Nullable
    private String androidId;
    @Nullable
    private String osVersion;
    @Nullable
    private String model;
    private int deviceWidth;
    private int deviceHeight;
    private float ppi;
    private float pixelRatio;
    @Nullable
    private String language;
    private int linearity;
    @Nullable
    private String carrier;
    @Nullable
    private String connectionType;
    @Nullable
    private Double lat;
    @Nullable
    private Double lon;
    private boolean gdprConsent;
    @Nullable
    private String extraUrlQuery;
    private int adWidth;
    private int adHeight;

    private RtbAdRequest(@NonNull String format) {
        this.format = format;
    }

    @NonNull
    public String getFormat() {
        return this.format;
    }

    @Nullable
    public String getAndroidId() {
        return this.androidId;
    }

    @Nullable
    public String getOsVersion() {
        return this.osVersion;
    }

    @Nullable
    public String getModel() {
        return this.model;
    }

    public int getDeviceWidth() {
        return this.deviceWidth;
    }

    public int getDeviceHeight() {
        return this.deviceHeight;
    }

    public float getPpi() {
        return this.ppi;
    }

    public float getPixelRatio() {
        return this.pixelRatio;
    }

    @Nullable
    public String getLanguage() {
        return this.language;
    }

    public int getLinearity() {
        return this.linearity;
    }

    @Nullable
    public String getCarrier() {
        return this.carrier;
    }

    @Nullable
    public String getConnectionType() {
        return this.connectionType;
    }

    @Nullable
    public Double getLat() {
        return this.lat;
    }

    @Nullable
    public Double getLon() {
        return this.lon;
    }

    public boolean isGdprConsent() {
        return this.gdprConsent;
    }

    public int getAdWidth() {
        return this.adWidth;
    }

    public int getAdHeight() {
        return this.adHeight;
    }

    @Nullable
    public String getExtraUrlQuery() {
        return this.extraUrlQuery;
    }

    public static class Builder {
        private final String format;
        private String androidId;
        private String osVersion;
        private String model;
        private int deviceWidth;
        private int deviceHeight;
        private float ppi;
        private float pixelRatio;
        private String language;
        private int linearity;
        private String carrier;
        private String connectionType;
        private Double lat;
        private Double lon;
        private boolean gdprConsent;
        private String extraUrlQuery;
        private int adWidth;
        private int adHeight;

        public Builder(@NonNull String format) {
            this.format = format;
        }

        @NonNull
        public Builder androidId(String androidId) {
            this.androidId = androidId;
            return this;
        }

        @NonNull
        public Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        @NonNull
        public Builder model(String model) {
            this.model = model;
            return this;
        }

        @NonNull
        public Builder deviceWidth(int deviceWidth) {
            this.deviceWidth = deviceWidth;
            return this;
        }

        @NonNull
        public Builder deviceHeight(int deviceHeight) {
            this.deviceHeight = deviceHeight;
            return this;
        }

        @NonNull
        public Builder ppi(float ppi) {
            this.ppi = ppi;
            return this;
        }

        @NonNull
        public Builder pixelRatio(float pixelRatio) {
            this.pixelRatio = pixelRatio;
            return this;
        }

        @NonNull
        public Builder linearity(int linearity) {
            this.linearity = linearity;
            return this;
        }

        @NonNull
        public Builder language(String language) {
            this.language = language;
            return this;
        }

        @NonNull
        public Builder carrier(String carrier) {
            this.carrier = carrier;
            return this;
        }

        @NonNull
        public Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @NonNull
        public Builder lat(Double lat) {
            this.lat = lat;
            return this;
        }

        @NonNull
        public Builder lon(Double lon) {
            this.lon = lon;
            return this;
        }

        @NonNull
        public Builder gdprConsent(boolean gdprConsent) {
            this.gdprConsent = gdprConsent;
            return this;
        }

        @NonNull
        public Builder extraUrlQuery(String extraUrlQuery) {
            this.extraUrlQuery = extraUrlQuery;
            return this;
        }

        @NonNull
        public Builder adWidth(int adWidth) {
            this.adWidth = adWidth;
            return this;
        }

        @NonNull
        public Builder adHeight(int adHeight) {
            this.adHeight = adHeight;
            return this;
        }

        @NonNull
        public RtbAdRequest build() {
            RtbAdRequest request = new RtbAdRequest(this.format);
            request.androidId = this.androidId;
            request.osVersion = this.osVersion;
            request.model = this.model;
            request.deviceWidth = this.deviceWidth;
            request.deviceHeight = this.deviceHeight;
            request.ppi = this.ppi;
            request.pixelRatio = this.pixelRatio;
            request.language = this.language;
            request.linearity = this.linearity;
            request.carrier = this.carrier;
            request.connectionType = this.connectionType;
            request.lat = this.lat;
            request.lon = this.lon;
            request.gdprConsent = this.gdprConsent;
            request.extraUrlQuery = this.extraUrlQuery;
            request.adWidth = this.adWidth;
            request.adHeight = this.adHeight;
            return request;
        }
    }
}

