/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.rtb;

import android.util.Xml;
import co.adcel.ads.rtb.VASTAd;
import co.adcel.logger.AdsATALog;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class VASTParser {
    private static final String ns = null;

    public VASTAd parse(String vastString) {
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
            parser.setInput((Reader)new StringReader(vastString));
            parser.nextTag();
            return this.readVAST(parser);
        }
        catch (XmlPullParserException e) {
            AdsATALog.e("VASTParser parse error: " + e.getMessage());
        }
        catch (IOException e) {
            AdsATALog.e("VASTParser parse error: " + e.getMessage());
        }
        return null;
    }

    private VASTAd readVAST(XmlPullParser parser) throws XmlPullParserException, IOException {
        VASTAd vastAd = null;
        parser.require(2, ns, "VAST");
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String name = parser.getName();
            if (name.equals("Ad")) {
                vastAd = this.readAd(parser);
                continue;
            }
            this.skip(parser);
        }
        return vastAd;
    }

    private VASTAd readAd(XmlPullParser parser) throws XmlPullParserException, IOException {
        VASTAd vastAd = null;
        parser.require(2, ns, "Ad");
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String name = parser.getName();
            if (name.equals("InLine")) {
                vastAd = this.readInLine(parser);
                continue;
            }
            this.skip(parser);
        }
        return vastAd;
    }

    private VASTAd readInLine(XmlPullParser parser) throws XmlPullParserException, IOException {
        parser.require(2, ns, "InLine");
        VASTAd vastAd = new VASTAd();
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String name = parser.getName();
            if (name.equals("AdSystem")) {
                vastAd.adSystem = this.readTag(parser, "AdSystem");
                continue;
            }
            if (name.equals("AdTitle")) {
                vastAd.adTitle = this.readTag(parser, "AdTitle");
                continue;
            }
            if (name.equals("Impression")) {
                vastAd.impressions.add(this.readTag(parser, "Impression"));
                continue;
            }
            if (name.equals("Creatives")) {
                List<VASTAd.Creative> creatives = this.readCreatives(parser);
                if (creatives.size() <= 0) continue;
                vastAd.creative = creatives.get(0);
                continue;
            }
            if (name.equals("Extensions")) {
                vastAd.extensions = this.readExtensions(parser);
                continue;
            }
            this.skip(parser);
        }
        return vastAd;
    }

    private List<VASTAd.Creative> readCreatives(XmlPullParser parser) throws XmlPullParserException, IOException {
        ArrayList<VASTAd.Creative> creatives = new ArrayList<VASTAd.Creative>();
        parser.require(2, ns, "Creatives");
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String name = parser.getName();
            if (name.equals("Creative")) {
                creatives.add(this.readCreative(parser));
                continue;
            }
            this.skip(parser);
        }
        return creatives;
    }

    private VASTAd.Creative readCreative(XmlPullParser parser) throws XmlPullParserException, IOException {
        VASTAd.Creative creative = null;
        parser.require(2, ns, "Creative");
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String name = parser.getName();
            if (name.equals("Linear")) {
                creative = this.readCreativeLinear(parser);
                continue;
            }
            this.skip(parser);
        }
        return creative;
    }

    private VASTAd.Creative readCreativeLinear(XmlPullParser parser) throws XmlPullParserException, IOException {
        parser.require(2, ns, "Linear");
        VASTAd.Creative creative = new VASTAd.Creative();
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String name = parser.getName();
            if (name.equals("Duration")) {
                creative.duration = this.readTag(parser, "Duration");
                continue;
            }
            if (name.equals("VideoClicks")) {
                creative.videoClicks = this.readVideoClicks(parser);
                continue;
            }
            if (name.equals("MediaFiles")) {
                creative.mediaFiles = this.readMediaFiles(parser);
                continue;
            }
            if (name.equals("TrackingEvents")) {
                creative.trackingEvents = this.readTrackingEvents(parser);
                continue;
            }
            this.skip(parser);
        }
        return creative;
    }

    private List<String> readVideoClicks(XmlPullParser parser) throws XmlPullParserException, IOException {
        ArrayList<String> links = new ArrayList<String>();
        parser.require(2, ns, "VideoClicks");
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String name = parser.getName();
            if (name.equals("ClickThrough")) {
                links.add(this.readTag(parser, "ClickThrough"));
                continue;
            }
            this.skip(parser);
        }
        return links;
    }

    private List<VASTAd.MediaFile> readMediaFiles(XmlPullParser parser) throws XmlPullParserException, IOException {
        ArrayList<VASTAd.MediaFile> mediaFiles = new ArrayList<VASTAd.MediaFile>();
        parser.require(2, ns, "MediaFiles");
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String name = parser.getName();
            if (name.equals("MediaFile")) {
                VASTAd.MediaFile mediaFile = new VASTAd.MediaFile();
                mediaFile.width = Integer.parseInt(parser.getAttributeValue(null, "width"));
                mediaFile.height = Integer.parseInt(parser.getAttributeValue(null, "height"));
                mediaFile.type = parser.getAttributeValue(null, "type");
                mediaFile.bitrate = Double.parseDouble(parser.getAttributeValue(null, "bitrate"));
                mediaFile.codec = parser.getAttributeValue(null, "codec");
                mediaFile.url = this.readTag(parser, "MediaFile");
                mediaFiles.add(mediaFile);
                continue;
            }
            this.skip(parser);
        }
        return mediaFiles;
    }

    private List<VASTAd.Tracking> readTrackingEvents(XmlPullParser parser) throws XmlPullParserException, IOException {
        ArrayList<VASTAd.Tracking> trackingEvents = new ArrayList<VASTAd.Tracking>();
        parser.require(2, ns, "TrackingEvents");
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String name = parser.getName();
            if (name.equals("Tracking")) {
                String event = parser.getAttributeValue(null, "event");
                String url = this.readTag(parser, "Tracking");
                trackingEvents.add(new VASTAd.Tracking(event, url));
                continue;
            }
            this.skip(parser);
        }
        return trackingEvents;
    }

    private Map<String, String> readExtensions(XmlPullParser parser) throws XmlPullParserException, IOException {
        HashMap<String, String> extensions = new HashMap<String, String>();
        parser.require(2, ns, "Extensions");
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String name = parser.getName();
            if (name.equals("Extension")) {
                String type = parser.getAttributeValue(null, "type");
                String value = this.readTag(parser, "Extension");
                extensions.put(type, value);
                continue;
            }
            this.skip(parser);
        }
        return extensions;
    }

    private String readTag(XmlPullParser parser, String tagName) throws IOException, XmlPullParserException {
        parser.require(2, ns, tagName);
        String title = this.readText(parser);
        parser.require(3, ns, tagName);
        return title;
    }

    private String readText(XmlPullParser parser) throws IOException, XmlPullParserException {
        String result = "";
        if (parser.next() == 4) {
            result = parser.getText();
            parser.nextTag();
        }
        return result.trim();
    }

    private void skip(XmlPullParser parser) throws XmlPullParserException, IOException {
        if (parser.getEventType() != 2) {
            throw new IllegalStateException();
        }
        int depth = 1;
        while (depth != 0) {
            switch (parser.next()) {
                case 3: {
                    --depth;
                    break;
                }
                case 2: {
                    ++depth;
                }
            }
        }
    }
}

