/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.rtb;

import android.content.Context;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.WindowManager;
import co.adcel.ads.rtb.InterstitialAd;
import co.adcel.ads.rtb.RtbAdRequest;
import co.adcel.ads.rtb.VASTAd;
import co.adcel.ads.rtb.VASTHelper;
import co.adcel.ads.rtb.VASTParser;
import co.adcel.ads.rtb.VideoAdView;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class VideoAd
extends InterstitialAd {
    private static final int SKIP_SECONDS = 5;
    private ScheduledExecutorService worker;
    private ScheduledFuture future;
    private VASTAd mVastAd;
    boolean mCanBeClosed = false;
    private int mScreenOrientation;
    private VASTHelper vastHelper;

    public VideoAd(Context context, String key, String options) {
        super(context, key, options);
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        int height = displayMetrics.heightPixels;
        int width = displayMetrics.widthPixels;
        this.mScreenOrientation = height > width ? 1 : 0;
    }

    @Override
    int getScreenOrientation() {
        return this.mScreenOrientation;
    }

    VASTAd getVastAd() {
        return this.mVastAd;
    }

    @Override
    RtbAdRequest.Builder createUriBuilder(Context context) {
        return new RtbAdRequest.Builder("video");
    }

    @Override
    View createView(final InterstitialAd.OnAdCompleted onAdCompleted) {
        return new VideoAdView(this.getContext(), this, new VideoAdView.VideoAdViewEventsListener(){

            @Override
            public void onVideoCompleted() {
                if (onAdCompleted != null) {
                    onAdCompleted.onAdCompleted();
                }
            }
        });
    }

    @Override
    void loadSuccess(int providerId) {
        VASTParser vastParser = new VASTParser();
        if (this.getAd().getVAST() != null) {
            this.mVastAd = vastParser.parse(this.getAd().getVAST());
            if (this.mVastAd == null) {
                this.loadFailed("Video ad parsing error. VAST is invalid");
            } else {
                if (this.mVastAd.creative != null && this.mVastAd.creative.mediaFiles.size() > 0) {
                    VASTAd.MediaFile mediaFile = this.mVastAd.creative.mediaFiles.get(0);
                    this.mScreenOrientation = mediaFile.height > mediaFile.width ? 1 : 0;
                }
                super.loadSuccess(providerId);
            }
        } else {
            this.loadFailed("Video ad format error. VAST is null");
        }
    }

    private VASTHelper getVastHelper() {
        if (this.vastHelper == null) {
            this.vastHelper = new VASTHelper();
        }
        return this.vastHelper;
    }

    @Override
    void trackImpression() {
        this.getVastHelper().trackImpression(this.getVastAd());
    }

    @Override
    void adShow() {
        this.startSkipTimer();
        super.adShow();
    }

    private int getSkipTime() {
        if (this.getAd().getSkip() > 0) {
            return this.getAd().getSkip();
        }
        return 5;
    }

    void startSkipTimer() {
        if (this.worker == null && this.future == null) {
            this.worker = Executors.newSingleThreadScheduledExecutor();
            this.future = this.worker.schedule(new Runnable(){

                @Override
                public void run() {
                    VideoAd.this.future = null;
                    VideoAd.this.worker = null;
                    VideoAd.this.setCanBeClosed();
                }
            }, (long)this.getSkipTime(), TimeUnit.SECONDS);
        }
    }

    @Override
    void click() {
        this.setCanBeClosed();
        List<String> clicks = this.mVastAd.creative.videoClicks;
        if (clicks != null && clicks.size() > 0) {
            this.openClickUrl(clicks.get(0));
        }
        super.click();
    }

    void setCanBeClosed() {
        this.mCanBeClosed = true;
        if (this.mOnAdCanBeClosed != null) {
            this.mOnAdCanBeClosed.onAdCanBeClosed();
        }
    }

    @Override
    boolean canBeClosed() {
        return this.mCanBeClosed;
    }
}

