/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.ads.rtb;

import android.app.Activity;
import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.VideoView;
import androidx.annotation.NonNull;
import co.adcel.ads.rtb.IAdView;
import co.adcel.ads.rtb.VASTAd;
import co.adcel.ads.rtb.VASTHelper;
import co.adcel.ads.rtb.VideoAd;
import co.adcel.logger.AdsATALog;
import java.util.Timer;
import java.util.TimerTask;

public class VideoAdView
extends FrameLayout
implements IAdView {
    private static final int MAX_WAIT_LOAD_TIME_SECONDS = 10;
    private VideoAd mVideoAd;
    private VideoAdViewEventsListener eventsListener;
    private ProgressBar mProgressBar;
    private VideoView mVideoView;
    private TextView mVideoTimeline;
    private Handler mHandler;
    private Timer mVideoTimer;
    int prevPlaybackTime = 0;
    private VASTHelper vastHelper;
    private MediaPlayer.OnCompletionListener onCompletionListener = new MediaPlayer.OnCompletionListener(){

        public void onCompletion(MediaPlayer mp) {
            VideoAdView.this.getVastHelper().trackEvent(VideoAdView.this.mVideoAd.getVastAd(), "complete");
            if (VideoAdView.this.mVideoTimer != null) {
                VideoAdView.this.mVideoTimer.cancel();
                VideoAdView.this.mVideoTimer = null;
            }
            if (VideoAdView.this.mVideoView != null) {
                VideoAdView.this.mVideoView.suspend();
                VideoAdView.this.mVideoView.stopPlayback();
            }
            VideoAdView.this.mVideoAd.setCanBeClosed();
            VideoAdView.this.fireOnVideoCompleted();
        }
    };
    private MediaPlayer.OnPreparedListener onPreparedListener = new MediaPlayer.OnPreparedListener(){

        public void onPrepared(MediaPlayer mp) {
            VideoAdView.this.mProgressBar.setVisibility(8);
            VideoAdView.this.getVastHelper().trackEvent(VideoAdView.this.mVideoAd.getVastAd(), "start");
            VideoAdView.this.mVideoAd.trackImpression();
            VideoAdView.this.mVideoAd.adShow();
            VideoAdView.this.startTimer();
            VideoAdView.this.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    VideoAdView.this.mVideoAd.click();
                }
            });
        }
    };
    private int position = 0;

    public VideoAdView(@NonNull Context context, VideoAd videoAd, VideoAdViewEventsListener eventsListener) {
        super(context);
        this.mVideoAd = videoAd;
        this.eventsListener = eventsListener;
        this.mHandler = new Handler(Looper.getMainLooper());
        this.setBackgroundColor(-16777216);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        params.gravity = 17;
        this.mVideoView = new VideoView(this.getContext());
        this.mVideoView.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mediaPlayer, int i, int i1) {
                AdsATALog.e("co.adcel.ads.rtb.VideoAdView: onError: " + i + " " + i1);
                VideoAdView.this.mVideoAd.setCanBeClosed();
                VideoAdView.this.mVideoAd.showFailed();
                VideoAdView.this.fireOnVideoCompleted();
                return false;
            }
        });
        this.mVideoView.setOnPreparedListener(this.onPreparedListener);
        this.mVideoView.setOnCompletionListener(this.onCompletionListener);
        this.addView((View)this.mVideoView, (ViewGroup.LayoutParams)params);
        float density = this.getResources().getDisplayMetrics().density;
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        layoutParams.gravity = 83;
        layoutParams.setMargins(0, (int)(5.0f * density), (int)(5.0f * density), 0);
        this.mVideoTimeline = new TextView(this.getContext());
        this.mVideoTimeline.setText((CharSequence)"buffering...");
        this.mVideoTimeline.setTextColor(-6710887);
        this.addView((View)this.mVideoTimeline, (ViewGroup.LayoutParams)layoutParams);
        layoutParams = new FrameLayout.LayoutParams(-2, -2);
        layoutParams.gravity = 17;
        this.mProgressBar = new ProgressBar(this.getContext());
        this.addView((View)this.mProgressBar, (ViewGroup.LayoutParams)layoutParams);
    }

    private void fireOnVideoCompleted() {
        if (this.eventsListener != null) {
            this.eventsListener.onVideoCompleted();
        }
    }

    private VASTHelper getVastHelper() {
        if (this.vastHelper == null) {
            this.vastHelper = new VASTHelper();
        }
        return this.vastHelper;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                VASTAd.MediaFile mediaFile = null;
                VASTAd.Creative creative = ((VideoAdView)VideoAdView.this).mVideoAd.getVastAd().creative;
                if (creative != null && creative.mediaFiles.size() > 0) {
                    mediaFile = ((VideoAdView)VideoAdView.this).mVideoAd.getVastAd().creative.mediaFiles.get(0);
                }
                if (mediaFile == null || mediaFile.url == null) {
                    VideoAdView.this.mVideoAd.showFailed();
                    return;
                }
                if (VideoAdView.this.mVideoView != null) {
                    VideoAdView.this.mVideoView.setVideoURI(Uri.parse((String)mediaFile.url));
                    VideoAdView.this.mVideoView.start();
                } else {
                    VideoAdView.this.mVideoAd.showFailed();
                }
                VideoAdView.this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (!VideoAdView.this.mVideoAd.isShown()) {
                            VideoAdView.this.mVideoAd.setCanBeClosed();
                        }
                    }
                }, 10000L);
            }
        };
        this.mHandler.post(runnable);
    }

    private void startTimer() {
        this.mVideoTimer = new Timer();
        this.mVideoTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ((Activity)VideoAdView.this.getContext()).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (VideoAdView.this.mVideoView != null) {
                            int currentTime = VideoAdView.this.mVideoView.getCurrentPosition();
                            int duration = VideoAdView.this.mVideoView.getDuration();
                            long time = Math.round(Math.ceil((duration - currentTime) / 1000));
                            if (currentTime >= duration / 4 && currentTime > VideoAdView.this.prevPlaybackTime && VideoAdView.this.prevPlaybackTime < duration / 4) {
                                VideoAdView.this.getVastHelper().trackEvent(VideoAdView.this.mVideoAd.getVastAd(), "firstQuartile");
                            } else if (currentTime >= duration / 2 && currentTime > VideoAdView.this.prevPlaybackTime && VideoAdView.this.prevPlaybackTime < duration / 2) {
                                VideoAdView.this.getVastHelper().trackEvent(VideoAdView.this.mVideoAd.getVastAd(), "midpoint");
                            } else if (currentTime >= duration / 4 * 3 && currentTime > VideoAdView.this.prevPlaybackTime && VideoAdView.this.prevPlaybackTime < duration / 4 * 3) {
                                VideoAdView.this.getVastHelper().trackEvent(VideoAdView.this.mVideoAd.getVastAd(), "thirdQuartile");
                            }
                            VideoAdView.this.prevPlaybackTime = currentTime;
                            VideoAdView.this.mVideoTimeline.setText((CharSequence)String.format("%s seconds remaining...", time));
                        }
                    }
                });
            }
        }, 500L, 500L);
    }

    @Override
    public void onPause() {
        this.getVastHelper().trackEvent(this.mVideoAd.getVastAd(), "pause");
        if (this.mVideoView != null) {
            this.position = this.mVideoView.getCurrentPosition();
            this.mVideoView.pause();
        }
    }

    @Override
    public void onResume() {
        this.getVastHelper().trackEvent(this.mVideoAd.getVastAd(), "resume");
        if (this.mVideoView != null) {
            this.mVideoView.seekTo(this.position);
            this.mVideoView.start();
        }
    }

    static interface VideoAdViewEventsListener {
        public void onVideoCompleted();
    }
}

