/*
 * Decompiled with CFR 0.152.
 */
package co.adcel.common;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import co.adcel.ads.mediation.AdFormatConfig;
import co.adcel.ads.mediation.AdNetworkConfig;
import co.adcel.ads.mediation.CredentialsResponse;
import co.adcel.ads.mediation.InterstitialAdFormatConfig;
import co.adcel.ads.mediation.MediationContext;
import co.adcel.common.AdProviderDTO;
import co.adcel.common.CacheSettings;
import co.adcel.common.Utilities;
import co.adcel.logger.AdsATALog;
import java.util.ArrayList;
import java.util.Map;
import java.util.Scanner;
import org.json.JSONArray;
import org.json.JSONException;

public class AdProviderConverter {
    private static final String OPTIONS = "options";
    private MediationContext mediationContext;

    public AdProviderConverter(MediationContext mediationContext) {
        this.mediationContext = mediationContext;
    }

    public void convert(@NonNull CredentialsResponse credentialsResponse) {
        this.convert(credentialsResponse.getBannerAdFormatConfig(), "banner");
        this.convert(credentialsResponse.getImageAdFormatConfig(), "image");
        this.convert(credentialsResponse.getInterstitialAdFormatConfig(), "interstitial");
        this.convert(credentialsResponse.getNativeAdFormatConfig(), "native");
        this.convert(credentialsResponse.getRewardAdFormatConfig(), "reward");
        this.convert(credentialsResponse.getVideoAdFormatConfig(), "video");
        this.convert(credentialsResponse.getAudioAdFormatConfig(), "audio");
    }

    private void convert(@Nullable AdFormatConfig adFormatConfig, @NonNull String adType) {
        if (adFormatConfig == null) {
            AdsATALog.i(String.format("----------\n#No data for %s type...", adType.toUpperCase()));
            return;
        }
        CacheSettings cv = new CacheSettings(0, 0, 0);
        if (adFormatConfig instanceof InterstitialAdFormatConfig) {
            InterstitialAdFormatConfig interstitialAdFormatConfig = (InterstitialAdFormatConfig)adFormatConfig;
            cv = new CacheSettings(interstitialAdFormatConfig.getCacheSize(), interstitialAdFormatConfig.getNthreads0(), interstitialAdFormatConfig.getNthreads());
        }
        this.mediationContext.getWaterfallCacheSettings().put(adType, cv);
        ArrayList<String> queue = new ArrayList<String>();
        this.mediationContext.getProvidersQueues().put(adType, queue);
        AdsATALog.i(String.format("----------\n#Structuring the received %s data...", adType.toUpperCase()));
        if (this.mediationContext.isInHouseUsed().booleanValue() && this.isExistsAndNoEmptyInHouseType(adType).booleanValue()) {
            queue.add("InHouse");
            this.mediationContext.putProvider("InHouse", adType, this.getDefaultInHouseProvider());
            AdsATALog.i("===========\nPROVIDER: InHouse\nType: inhouse Params: --: --");
        }
        for (AdNetworkConfig adNetworkConfig : adFormatConfig.getAdNetworksConfigs()) {
            String name = adNetworkConfig.getName();
            AdProviderDTO provider = this.convert(name, adNetworkConfig);
            if (provider == null) continue;
            queue.add(name);
            this.mediationContext.putProvider(name, adType, provider);
            AdsATALog.i("===========\nPROVIDER: " + name + "\nParams: " + provider.getProviderECPM() + ": " + provider.getProviderWeight());
        }
    }

    private AdProviderDTO getDefaultInHouseProvider() {
        AdProviderDTO provider = new AdProviderDTO();
        provider.setProviderId(String.valueOf(30));
        provider.setProviderName("InHouse");
        provider.setProviderWeight("999");
        return provider;
    }

    private void fillCredsSizes(@NonNull AdProviderDTO providerDTO, @Nullable Map<String, Map<String, String>> credsSizes, @Nullable String appIdName, @Nullable String appKeyName) {
        if (credsSizes == null) {
            return;
        }
        for (Map.Entry<String, Map<String, String>> entry : credsSizes.entrySet()) {
            String key = entry.getKey();
            Map<String, String> size = credsSizes.get(key);
            Scanner scan = new Scanner(key);
            scan.useDelimiter("x");
            int width = Integer.parseInt(scan.next());
            int height = Integer.parseInt(scan.next());
            scan.close();
            String appId = null;
            String appKey = null;
            if (appIdName != null) {
                appId = size.get(appIdName);
            }
            if (appKeyName != null) {
                appKey = size.get(appKeyName);
            }
            providerDTO.addSize(width, height, appId, appKey);
        }
    }

    protected AdProviderDTO convert(String name, AdNetworkConfig adNetworkConfig) {
        String appKey;
        String appKey2;
        String appId;
        AdProviderDTO providerDTO = new AdProviderDTO();
        providerDTO.setProviderId(String.valueOf(adNetworkConfig.getId()));
        providerDTO.setProviderName(adNetworkConfig.getName());
        providerDTO.setProviderECPM(adNetworkConfig.getEcpm());
        providerDTO.setProviderWeight(String.valueOf(adNetworkConfig.getWeight()));
        AdNetworkConfig.Options opts = adNetworkConfig.getOpts();
        providerDTO.setMaxShows(opts.getMaxShows());
        providerDTO.setInactiveTimeout(opts.getInactiveTimeout());
        Map<String, String> creds = adNetworkConfig.getCredentials();
        Map<String, Map<String, String>> credsSizes = adNetworkConfig.getCredentialsBySizes();
        Map<String, String> zones = adNetworkConfig.getZones();
        if (zones != null) {
            for (Map.Entry<String, String> entry : zones.entrySet()) {
                providerDTO.getZones().put(entry.getKey(), entry.getValue());
            }
        }
        if (name.equals("AdColony")) {
            appId = creds.get("appId");
            appKey2 = creds.get("zoneId");
            if (appId == null || appKey2 == null || appId.length() == 0 || appKey2.length() == 0) {
                AdsATALog.i(String.format("Provider %s is not configured", name));
                return null;
            }
            providerDTO.setAppId(appId);
            providerDTO.setAppKey(appKey2);
            this.fillCredsSizes(providerDTO, credsSizes, "appId", "zoneId");
            return providerDTO;
        }
        if (name.equals("Google Admob")) {
            appId = creds.get("placementId");
            if (appId == null || appId.length() == 0) {
                AdsATALog.i(String.format("Provider %s is not configured", name));
                return null;
            }
            providerDTO.setAppId(appId);
            this.fillCredsSizes(providerDTO, credsSizes, "placementId", null);
            return providerDTO;
        }
        if (name.equals("Applovin")) {
            appId = creds.get("SDKKey");
            appKey2 = creds.get("zoneId");
            providerDTO.setAppId(appId);
            providerDTO.setAppKey(appKey2);
            this.fillCredsSizes(providerDTO, credsSizes, "SDKKey", "zoneId");
            return providerDTO;
        }
        if (name.equals("InMobi")) {
            appId = creds.get("ACCOUNT_ID");
            appKey2 = creds.get("PLACEMENT_ID");
            if (appId == null || appKey2 == null || appId.length() == 0 || appKey2.length() == 0) {
                AdsATALog.i(String.format("Provider %s is not configured", name));
                return null;
            }
            providerDTO.setAppId(appId);
            providerDTO.setAppKey(appKey2);
            this.fillCredsSizes(providerDTO, credsSizes, "ACCOUNT_ID", "PLACEMENT_ID");
            return providerDTO;
        }
        if (name.equals("MyTarget")) {
            appId = creds.get("SLOT_ID");
            if (appId == null || appId.length() == 0) {
                AdsATALog.i(String.format("Provider %s is not configured", name));
                return null;
            }
            providerDTO.setAppId(appId);
            this.fillCredsSizes(providerDTO, credsSizes, "SLOT_ID", null);
            return providerDTO;
        }
        if (name.equals("StartApp")) {
            appId = creds.get("appId");
            appKey2 = creds.get("developerId");
            if (appId == null || appKey2 == null || appId.length() == 0 || appKey2.length() == 0) {
                AdsATALog.i(String.format("Provider %s is not configured", name));
                return null;
            }
            providerDTO.setAppId(appId);
            providerDTO.setAppKey(appKey2);
            this.fillCredsSizes(providerDTO, credsSizes, "appId", "developerId");
            return providerDTO;
        }
        if (name.equals("UnityAds")) {
            appId = creds.get("GAME_ID");
            appKey2 = creds.get("zone_id");
            if (appId == null || appKey2 == null || appId.length() == 0 || appKey2.length() == 0) {
                AdsATALog.i(String.format("Provider %s is not configured", name));
                return null;
            }
            providerDTO.setAppId(appId);
            providerDTO.setAppKey(appKey2);
            this.fillCredsSizes(providerDTO, credsSizes, "GAME_ID", "zone_id");
            return providerDTO;
        }
        if (name.equals("Smaato")) {
            appId = creds.get("publisherId");
            appKey2 = creds.get("spaceId");
            if (appId == null || appKey2 == null || appId.length() == 0 || appKey2.length() == 0) {
                AdsATALog.i(String.format("Provider %s is not configured", name));
                return null;
            }
            providerDTO.setAppId(appId);
            providerDTO.setAppKey(appKey2);
            this.fillCredsSizes(providerDTO, credsSizes, "publisherId", "spaceId");
            return providerDTO;
        }
        if (name.equals("Yandex")) {
            appId = creds.get("BLOCK_ID");
            appKey2 = creds.get("API_KEY");
            if (appId == null || appKey2 == null || appId.length() == 0 || appKey2.length() == 0) {
                AdsATALog.i(String.format("Provider %s is not configured", name));
                return null;
            }
            providerDTO.setAppId(appId);
            providerDTO.setAppKey(appKey2);
            this.fillCredsSizes(providerDTO, credsSizes, "BLOCK_ID", "API_KEY");
            return providerDTO;
        }
        if (name.equals("Amazon Mobile Ads")) {
            appKey = creds.get("key");
            if (appKey == null || appKey.length() == 0) {
                AdsATALog.i(String.format("Provider %s is not configured", name));
                return null;
            }
            providerDTO.setAppKey(appKey);
            this.fillCredsSizes(providerDTO, credsSizes, null, "key");
            return providerDTO;
        }
        if (name.equals("Vungle")) {
            appId = creds.get("appId");
            appKey2 = creds.get("placementId");
            if (appId == null || appKey2 == null || appId.length() == 0 || appKey2.length() == 0) {
                AdsATALog.i(String.format("Provider %s is not configured", name));
                return null;
            }
            providerDTO.setAppId(appId);
            providerDTO.setAppKey(appKey2);
            this.fillCredsSizes(providerDTO, credsSizes, "appId", "placementId");
            return providerDTO;
        }
        if (name.equals("Supersonic")) {
            appId = creds.get("appKey");
            if (appId == null || appId.length() == 0) {
                AdsATALog.i(String.format("Provider %s is not configured", name));
                return null;
            }
            providerDTO.setAppId(appId);
            return providerDTO;
        }
        if (name.equals("Nativex")) {
            appId = creds.get("App ID");
            appKey2 = creds.get("Placement");
            if (appId == null || appKey2 == null || appId.length() == 0 || appKey2.length() == 0) {
                AdsATALog.i(String.format("Provider %s is not configured", name));
                return null;
            }
            providerDTO.setAppId(appId);
            providerDTO.setAppKey(appKey2);
            return providerDTO;
        }
        if (name.equals("Facebook")) {
            appKey = creds.get("placementId");
            if (appKey == null || appKey.length() == 0) {
                AdsATALog.i(String.format("Provider %s is not configured", name));
                return null;
            }
            providerDTO.setAppKey(appKey);
            this.fillCredsSizes(providerDTO, credsSizes, null, "placementId");
            return providerDTO;
        }
        if (name.equals("MoPub")) {
            appKey = creds.get("ADUNIT_ID");
            if (appKey == null || appKey.length() == 0) {
                AdsATALog.i(String.format("Provider %s is not configured", name));
                return null;
            }
            providerDTO.setAppKey(appKey);
            this.fillCredsSizes(providerDTO, credsSizes, null, "ADUNIT_ID");
            return providerDTO;
        }
        if (name.equals("Tapjoy")) {
            appId = creds.get("SDKKey");
            appKey2 = creds.get("PlacementName");
            if (appId == null || appKey2 == null || appId.length() == 0 || appKey2.length() == 0) {
                AdsATALog.i(String.format("Provider %s is not configured", name));
                return null;
            }
            providerDTO.setAppId(appId);
            providerDTO.setAppKey(appKey2);
            this.fillCredsSizes(providerDTO, credsSizes, "SDKKey", "PlacementName");
            return providerDTO;
        }
        if (name.equals("Ogury")) {
            appId = creds.get("ApiKey");
            appKey2 = creds.get("AdUnitID");
            if (appId == null || appKey2 == null || appId.length() == 0 || appKey2.length() == 0) {
                AdsATALog.i(String.format("Provider %s is not configured", name));
                return null;
            }
            providerDTO.setAppId(appId);
            providerDTO.setAppKey(appKey2);
            return providerDTO;
        }
        if (name.equals("Instreamatic")) {
            appId = creds.get("slotId");
            appKey2 = creds.get("region");
            if (appId == null || appKey2 == null || appId.length() == 0 || appKey2.length() == 0) {
                AdsATALog.i(String.format("Provider %s is not configured", name));
                return null;
            }
            providerDTO.setAppId(appId);
            providerDTO.setAppKey(appKey2);
            return providerDTO;
        }
        if (name.equals("RTB")) {
            providerDTO.setOptions(creds.get(OPTIONS));
            return providerDTO;
        }
        if (name.equals("Criteo")) {
            appId = creds.get("publisherId");
            appKey2 = creds.get("adUnit");
            if (appId == null || appKey2 == null || appId.length() == 0 || appKey2.length() == 0) {
                AdsATALog.i(String.format("Provider %s is not configured", name));
                return null;
            }
            providerDTO.setAppId(appId);
            providerDTO.setAppKey(appKey2);
            this.fillCredsSizes(providerDTO, credsSizes, "publisherId", "adUnit");
            return providerDTO;
        }
        if (name.equals("Tiktok")) {
            appId = creds.get("App ID");
            appKey2 = creds.get("Slot ID");
            if (appId == null || appKey2 == null || appId.length() == 0 || appKey2.length() == 0) {
                AdsATALog.i(String.format("Provider %s is not configured", name));
                return null;
            }
            providerDTO.setAppId(appId);
            providerDTO.setAppKey(appKey2);
            return providerDTO;
        }
        return null;
    }

    private Boolean isExistsAndNoEmptyInHouseType(String type) {
        Context context = this.mediationContext.getContext();
        if (context == null) {
            return false;
        }
        String jsonFromCache = Utilities.readStringLocalData(context, String.format("providerInHouseParams_%s", type));
        if (jsonFromCache != null && jsonFromCache.length() != 0) {
            try {
                JSONArray json = new JSONArray(jsonFromCache);
                if (json != null && json.length() != 0) {
                    return true;
                }
            }
            catch (JSONException e) {
                AdsATALog.e("AdProviderParser parse error: " + e.getMessage());
            }
        }
        return false;
    }
}

